/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.model.menu;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.mini.framework.third.weixin.server.model.menu.ButtonTypeDeserializer;
import com.mini.framework.third.weixin.server.model.menu.ButtonTypeSerializer;
import com.mini.framework.third.weixin.server.model.menu.WeixinServerButton;
import com.mini.framework.third.weixin.server.model.menu.WeixinServerButtonType;
import com.mini.framework.util.string.GsonUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class WeixinServerMenu {
    @SerializedName(value="button")
    private List<WeixinServerButton> buttons = new ArrayList<WeixinServerButton>();

    public List<WeixinServerButton> getButtons() {
        return this.buttons;
    }

    public void setButtons(List<WeixinServerButton> buttons) {
        this.buttons = buttons;
    }

    public static WeixinServerMenu create() {
        return new WeixinServerMenu();
    }

    public WeixinServerMenu addButton(WeixinServerButton button) {
        return this.addButtons(button);
    }

    public WeixinServerMenu addButtons(List<WeixinServerButton> buttons) {
        this.buttons.addAll(buttons);
        return this;
    }

    public WeixinServerMenu addButtons(WeixinServerButton ... buttons) {
        return this.addButtons(Stream.of(buttons).collect(Collectors.toList()));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static UnaryOperator<GsonBuilder> gsonBulderOperator() {
        Type type = new TypeToken<List<WeixinServerButton>>(){}.getType();
        return builder -> builder.registerTypeAdapter(type, (Object)new JsonDeserializer<List<WeixinServerButton>>(){

            public List<WeixinServerButton> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                ArrayList<WeixinServerButton> beans = new ArrayList<WeixinServerButton>();
                if (json.isJsonObject()) {
                    json = json.getAsJsonObject().get("list");
                }
                if (json.isJsonArray()) {
                    JsonArray array = json.getAsJsonArray();
                    array.iterator().forEachRemaining(bean -> beans.add((WeixinServerButton)context.deserialize(bean, WeixinServerButton.class)));
                }
                return beans;
            }
        }).registerTypeAdapter(WeixinServerButtonType.class, (Object)new ButtonTypeSerializer()).registerTypeAdapter(WeixinServerButtonType.class, (Object)new ButtonTypeDeserializer());
    }

    public String toWeixinReqMessage() {
        return GsonUtil.createBaseBuilder(WeixinServerMenu.gsonBulderOperator()).create().toJson((Object)this);
    }
}

