/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.util.tpmsg;

import com.mini.framework.third.weixin.server.util.tpmsg.WeixinServerIndustryDto;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.JsonEditUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WeixinTempAdapter {
    public static List<String> getIndustrysFromJson(String industryJson) {
        AssertUtil.assertMethodRequire((Object)industryJson, (String)"industryJson");
        List<WeixinServerIndustryDto> industrys = WeixinTempAdapter.parseIndustrysFromJson(industryJson);
        return industrys.stream().map(WeixinServerIndustryDto::industrysName).collect(Collectors.toList());
    }

    public static List<WeixinServerIndustryDto> parseIndustrysFromJson(String industryJson) {
        AssertUtil.assertMethodRequire((Object)industryJson, (String)"industryJson");
        String[][] namespaces = new String[][]{{"primary_industry", "first_class"}, {"primary_industry", "second_class"}, {"secondary_industry", "first_class"}, {"secondary_industry", "second_class"}};
        List matchs = JsonEditUtil.getJsonMapNamespaceValues((String)industryJson, (String[][])namespaces);
        WeixinServerIndustryDto primaryIndustry = new WeixinServerIndustryDto(true, (String)matchs.get(0), (String)matchs.get(1));
        WeixinServerIndustryDto secondaryIndustry = new WeixinServerIndustryDto(false, (String)matchs.get(2), (String)matchs.get(3));
        return Stream.of(primaryIndustry, secondaryIndustry).filter(WeixinServerIndustryDto::existence).collect(Collectors.toList());
    }
}

