/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.util.tpmsg;

import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.third.weixin.server.util.tpmsg.TempKeyword;
import com.mini.framework.third.weixin.server.util.tpmsg.WeixinTempDoc;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.RegexUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class WeixinTempDocFactory {
    private static final String pattern = WeixinTempDocFactory.getPattern();
    private static final String otherPattern = "[\\S\\s]*";
    private static final String keyPattern = "\\{\\{(.*)\\.DATA\\}\\}";

    private static String getPattern() {
        CharSequence[] patternItems = new String[]{"\u7f16\u53f7", "(.*)", "\u6807\u9898", "(.*)", "\u884c\u4e1a", "(.*)", "\u4f7f\u7528\u4eba\u6570", "(.*)", "\u6700\u540e\u4fee\u6539\u65f6\u95f4", "(.*)", "\u8be6\u7ec6\u5185\u5bb9", "([\\s\\S]+)"};
        return String.join((CharSequence)"\n", patternItems);
    }

    public static WeixinTempDoc tryParse(String docText) {
        return WeixinTempDocFactory.parseFromText(docText).orElse(null);
    }

    public static Optional<WeixinTempDoc> parseFromText(String docText) {
        String[] items = RegexUtil.getMatch((String)pattern, (String)docText, (int[])new int[]{1, 2, 3, 4, 5, 6});
        if (items == null) {
            return Optional.empty();
        }
        WeixinTempDoc doc = new WeixinTempDoc();
        doc.setDocId(items[0]);
        doc.setTitle(items[1]);
        doc.setIndustry(items[2]);
        doc.setExample(items[5]);
        WeixinTempDocFactory.parseKeywords(doc);
        return Optional.of(doc);
    }

    private static final String getWeixinRreplace(String key) {
        return String.format("{{%s.DATA}}", key);
    }

    private static final String getRreplace(String key) {
        return String.format("{{%s}}", key);
    }

    @Deprecated
    public static void parseKeywords(WeixinTempDoc doc) {
        ArrayList<TempKeyword> keywords = new ArrayList<TempKeyword>();
        String exampleReplace = WeixinTempDocFactory.parseKeywords(doc.getExample(), keywords);
        doc.setExampleReplace(exampleReplace);
    }

    @Deprecated
    public static List<TempKeyword> parseKeywords(String template) {
        ArrayList<TempKeyword> keywords = new ArrayList<TempKeyword>();
        WeixinTempDocFactory.parseKeywords(template, keywords);
        return keywords;
    }

    @Deprecated
    public static String parseKeywords(String template, List<TempKeyword> keywords) {
        int length = template.split(keyPattern).length;
        Object[] others = new String[length + 1];
        Arrays.fill(others, otherPattern);
        String pattern = String.join((CharSequence)keyPattern, (CharSequence[])others);
        Optional keysOptional = RegexUtil.getMatchItems((String)pattern, (String)template);
        AssertUtil.assertNoBadReq((boolean)keysOptional.isPresent(), (StatusCode)Status.BadReq.illParam, (String)"\u5339\u914d\u4e0d\u5230\u5360\u4f4d\u6570\u636e", (Object[])new Object[]{template});
        List keys = (List)keysOptional.get();
        keys.forEach(key -> keywords.add(new TempKeyword((String)key, null, null)));
        String replace = template;
        for (String key2 : keys) {
            replace = replace.replace(WeixinTempDocFactory.getWeixinRreplace(key2), WeixinTempDocFactory.getRreplace(key2));
        }
        return replace;
    }
}

