/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.util;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.http.HttpResStatusUtil;
import com.mini.framework.util.string.RegexUtil;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeadResourseUtil {
    private static Logger logger = LogManager.getLogger(HeadResourseUtil.class);

    public static String findWeixinPhotoResourse(String weixinRes) {
        String[] weixinPhotoRegexs;
        for (String regex : weixinPhotoRegexs = new String[]{"^http.*wx.qlogo.cn.*/132$", "^http.*thirdwx.qlogo.cn.*/132$"}) {
            String match = RegexUtil.getMatch((String)regex, (String)weixinRes);
            if (match == null) continue;
            return match.substring(0, weixinRes.length() - 3) + "0";
        }
        return null;
    }

    public static String tryChangeWeixinPhoto(String weixinRes, Function<String, String> resChanger) {
        AssertUtil.assertMethodRequire((Object)weixinRes, (String)"weixinRes");
        String res = HeadResourseUtil.findWeixinPhotoResourse(weixinRes);
        if (res != null && HttpResStatusUtil.isExist((String)res)) {
            try {
                return resChanger.apply(res);
            }
            catch (Throwable e) {
                logger.debug("\u5c1d\u8bd5\u6362\u53d6\u8d44\u6e90\u65f6\u51fa\u9519,res:[{}]", (Object)res, (Object)e);
            }
        }
        return weixinRes;
    }
}

