/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.annotation;

import com.mini.framework.core.code.standard.style01.flag.define.CodeStandardDefineFindList;
import com.mini.framework.core.code.standard.style01.flag.define.CodeStandardDefineFindOne;
import com.mini.framework.core.exception.HandleReflectException;
import com.mini.framework.util.reflect.ReflectUtil;
import com.mini.framework.util.relation.ShipUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AnnotationUtil {
    @CodeStandardDefineFindOne
    public static <A extends Annotation> Optional<A> findFieldAnnotation(Field field, Class<A> annotationClass) {
        return AnnotationUtil.findElementAnnotation(field, annotationClass);
    }

    @CodeStandardDefineFindOne
    public static <A extends Annotation> Optional<A> findMethodAnnotation(Method method, Class<A> annotationClass) {
        return AnnotationUtil.findElementAnnotation(method, annotationClass);
    }

    @CodeStandardDefineFindOne
    public static <A extends Annotation> Optional<A> findClassAnnotation(Class<?> clazz, Class<A> annotationClass) {
        return AnnotationUtil.findElementAnnotation(clazz, annotationClass);
    }

    @CodeStandardDefineFindList
    public static List<Annotation> findElementAnnotations(AnnotatedElement annotatedElement, List<Class<? extends Annotation>> annotationClassList) {
        return annotationClassList.stream().map(annotationClass -> AnnotationUtil.findElementAnnotation(annotatedElement, annotationClass)).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList());
    }

    @CodeStandardDefineFindOne
    public static <A extends Annotation> Optional<A> findElementAnnotation(AnnotatedElement annotatedElement, Class<A> annotationClass) {
        if (!ReflectUtil.matchOneClassLoader(annotatedElement, annotationClass)) {
            String annotationClassName = annotationClass.getName();
            try {
                annotationClass = annotationClass.getClassLoader().loadClass(annotationClassName);
            }
            catch (ClassNotFoundException e) {
                throw new HandleReflectException((Throwable)e, "annotationClass\u5bf9\u5e94\u7684\u7c7b\u52a0\u8f7d\u5668\u65e0\u6cd5\u52a0\u8f7d\u7c7b:[%s]", new Object[]{annotationClassName});
            }
        }
        return Optional.ofNullable(annotatedElement.getAnnotation(annotationClass));
    }

    public static <A extends Annotation> void fillElementDeepSortedAnnotations(ArrayList<A> foundAnnotations, Set<String> loopedClassNames, AnnotatedElement annotatedElement, Class<A> annotationClass) {
        Predicate<Annotation> annotationMatchTargetClass = annotation -> annotation.annotationType().getName().equals(annotationClass.getName());
        Stream.of(annotatedElement.getAnnotations()).forEach(nextAnnotation -> {
            if (annotationMatchTargetClass.test((Annotation)nextAnnotation)) {
                foundAnnotations.add(nextAnnotation);
            }
            if (!loopedClassNames.contains(nextAnnotation.annotationType().getName())) {
                loopedClassNames.add(nextAnnotation.annotationType().getName());
                AnnotationUtil.fillElementDeepSortedAnnotations(foundAnnotations, loopedClassNames, nextAnnotation.annotationType(), annotationClass);
            }
        });
    }

    @CodeStandardDefineFindList
    public static <A extends Annotation> ArrayList<A> findElementDeepSortedAnnotations(AnnotatedElement annotatedElement, Class<A> annotationClass) {
        ArrayList result = new ArrayList();
        LinkedHashSet<String> loopedClassNames = new LinkedHashSet<String>();
        AnnotationUtil.fillElementDeepSortedAnnotations(result, loopedClassNames, annotatedElement, annotationClass);
        return result;
    }

    @CodeStandardDefineFindList
    public static <A extends Annotation> ArrayList<A> findElementDeepSortedAnnotationsDistinct(AnnotatedElement annotatedElement, Class<A> annotationClass) {
        ArrayList<A> fullList = AnnotationUtil.findElementDeepSortedAnnotations(annotatedElement, annotationClass);
        ShipUtil.distinct(fullList, Objects::hashCode);
        return fullList;
    }
}

