/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.aspect;

import com.mini.framework.core.exception.HandleException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;

public class AspectBeanUtil {
    public static String typeMethodArgsInfo(JoinPoint joinPoint) {
        Method targetMethod = AspectBeanUtil.getMethod(joinPoint);
        String methodName = targetMethod.getName();
        String className = targetMethod.getDeclaringClass().getName();
        Object[] args = joinPoint.getArgs();
        String argsMsg = StringUtils.join((Object[])args, (String)",");
        String info = String.format("%s.%s(%s)", className, methodName, argsMsg);
        return info;
    }

    public static <T extends Annotation> T getAnnotation(JoinPoint joinPoint, Class<T> annotationClass) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        return targetMethod.getAnnotation(annotationClass);
    }

    public static <T> T getParam(JoinPoint joinPoint, Class<T> paramSuper) throws HandleException {
        Object[] args = joinPoint.getArgs();
        Method method = AspectBeanUtil.getMethod(joinPoint);
        return AspectBeanUtil.queryParamByClass(joinPoint, paramSuper).orElseThrow(() -> new HandleException(Status.Handle.def, "\u53c2\u6570\u5217\u8868:%s(%s)\u4e2d\u5fc5\u987b\u5305\u542b%s", new Object[]{method, StringUtils.join((Object[])args, (String)","), paramSuper}));
    }

    public static <A extends Annotation> Optional<?> queryParamByAnnotation(JoinPoint joinPoint, Class<A> flag) {
        AssertUtil.assertMethodRequire(joinPoint, "joinPoint");
        Parameter[] params = AspectBeanUtil.getMethod(joinPoint).getParameters();
        Object[] args = joinPoint.getArgs();
        AssertUtil.assertNotFatalProgramConfig(params.length == args.length, Status.Server.programConfigJava, "params:[%s].length==args:[%s].length\u5fc5\u987b\u4e3atrue", params, args);
        ArrayList<Integer> haveFlagIndexes = new ArrayList<Integer>();
        for (int index2 = 0; index2 < params.length; ++index2) {
            if (params[index2].getAnnotation(flag) == null) continue;
            haveFlagIndexes.add(index2);
        }
        return haveFlagIndexes.stream().map(index -> args[index]).filter(Objects::nonNull).findFirst();
    }

    public static <T> Optional<T> queryParamByClass(JoinPoint joinPoint, Class<T> paramSuper) {
        Object[] args;
        AssertUtil.assertMethodRequire(paramSuper, "paramSuper");
        AssertUtil.assertMethodRequire(joinPoint, "joinPoint");
        for (Object arg : args = joinPoint.getArgs()) {
            if (!paramSuper.isAssignableFrom(arg.getClass())) continue;
            return Optional.of(arg);
        }
        return Optional.empty();
    }

    public static Method getMethod(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        return method;
    }

    public static <T> List<T> listParam(JoinPoint joinPoint, Class<T> paramSuper) {
        Object[] args = joinPoint.getArgs();
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object arg : args) {
            if (!paramSuper.isAssignableFrom(arg.getClass())) continue;
            list.add(arg);
        }
        return list;
    }
}

