/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.asserts;

import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.util.asserts.AssertUtil;
import org.apache.commons.lang3.ArrayUtils;

public interface TypeSwitchAssert {
    default public <T extends TypeSwitchAssert> T validateNext(T next, StatusCode status, String message, Object ... params) {
        AssertUtil.assertNoBadReq(this.ifNext(next), status, message, params);
        return next;
    }

    @Deprecated
    default public <T extends TypeSwitchAssert> T valiNext(T next, StatusCode status, String message, Object ... params) {
        return this.validateNext(next, status, message, params);
    }

    @Deprecated
    default public <T extends TypeSwitchAssert> T valiNext(T next) {
        return this.validateNext(next);
    }

    default public <T extends TypeSwitchAssert> T validateNext(T next) {
        return this.valiNext(next, Status.BadReq.statusSwitch, "\u72b6\u6001:[%s]\u4e0d\u80fd\u5207\u6362\u5230\u72b6\u6001:[%s]", this.showSelfTitle(), next.showSelfTitle());
    }

    default public <T extends TypeSwitchAssert> boolean ifNext(T next) {
        AssertUtil.assertMethodRequire(next, "next");
        Object[] nexts = this.showNexts();
        int index = ArrayUtils.indexOf((Object[])nexts, (Object)next.toString());
        return index >= 0;
    }

    @Deprecated
    default public boolean ifFinalStatus() {
        String[] nexts = this.showNexts();
        return nexts.length > 0;
    }

    default public boolean ifEndStatus() {
        String[] nexts = this.showNexts();
        return nexts.length == 0;
    }

    public String[] showNexts();

    default public String showSelfName() {
        return this.toString();
    }

    default public String showSelfTitle() {
        return this.showSelfName();
    }
}

