/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.bean;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.bean.VarUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public class ArrayUtil {
    public static Set<Integer> toSetFromInt(int[] ints) {
        AssertUtil.assertMethodRequire(ints, "ints");
        return ArrayUtil.toSetFromInt(ints, () -> new HashSet());
    }

    public static Set<Integer> toSetFromInt(int[] ints, Supplier<Set<Integer>> ifNull) {
        if (ints == null || ints.length == 0) {
            return ifNull.get();
        }
        Integer[] arr = ArrayUtils.toObject((int[])ints);
        return Stream.of(arr).collect(Collectors.toSet());
    }

    public static Set<String> toSetFromString(String[] values, Supplier<Set<String>> ifNull) {
        if (values == null || values.length == 0) {
            return ifNull.get();
        }
        return Stream.of(values).collect(Collectors.toSet());
    }

    public static <T> Set<T> toSet(T[] values, Supplier<Set<T>> ifNull) {
        if (values == null || values.length == 0) {
            return ifNull.get();
        }
        return Stream.of(values).collect(Collectors.toSet());
    }

    public static <T, R> List<R> mapList(T[] array, Function<T, R> fun) {
        return ArrayUtil.mapList(Stream.of(array).collect(Collectors.toList()), fun);
    }

    public static <T, R> List<R> mapList(Collection<T> array, Function<T, R> fun) {
        return array.stream().map(fun).collect(Collectors.toList());
    }

    public static <T, R> Set<R> mapSet(Collection<T> array, Function<T, R> fun) {
        return array.stream().map(fun).collect(Collectors.toSet());
    }

    public static <C, E> E findElement(C condition, Collection<E> target, Function<E, C> conditionGetter) {
        AssertUtil.assertMethodRequire(condition, "condition");
        return target.stream().filter(e -> condition.equals(conditionGetter.apply(e))).findFirst().orElse(null);
    }

    public static <C, E, F> F findField(C condition, Collection<E> target, Function<E, C> conditionGetter, Function<E, F> fieldGetter) {
        AssertUtil.assertMethodRequire(condition, "condition");
        E element = ArrayUtil.findElement(condition, target, conditionGetter);
        return element == null ? null : (F)fieldGetter.apply(element);
    }

    public static <C, E, F> List<F> findFields(Collection<C> conditions, Collection<E> target, Function<E, C> conditionGetter, Function<E, F> fieldGetter) {
        return conditions.stream().map(condition -> ArrayUtil.findField(condition, target, conditionGetter, fieldGetter)).filter(f -> f != null).collect(Collectors.toList());
    }

    public static <C, E> List<E> findElements(Collection<C> conditions, Collection<E> target, Function<E, C> conditionGetter) {
        return conditions.stream().map(condition -> ArrayUtil.findElement(condition, target, conditionGetter)).filter(f -> f != null).collect(Collectors.toList());
    }

    public static <R, C, E> List<E> findElements(Collection<R> reses, Function<R, C> resConditionGetter, Collection<E> target, Function<E, C> conditionGetter) {
        Collection conditions = reses.stream().map(resConditionGetter).collect(Collectors.toList());
        return conditions.stream().map(condition -> ArrayUtil.findElement(condition, target, conditionGetter)).filter(f -> f != null).collect(Collectors.toList());
    }

    public static <T> void remove(Collection<T> coll, Predicate<T> filter) {
        Iterator<T> it = coll.iterator();
        while (it.hasNext()) {
            T item = it.next();
            if (!filter.test(item)) continue;
            it.remove();
        }
    }

    public static <E, K> Comparator<E> asListComparator(List<K> keyList, Function<E, K> keyOfElement) {
        return ArrayUtil.asListComparator(keyList, keyOfElement, Function.identity());
    }

    public static <E, T, K> Comparator<E> asListComparator(List<T> targetList, Function<E, K> keyOfElement, Function<T, K> keyOfTarget) {
        Function<Object, Integer> indexOfElement = element -> {
            Object key = keyOfElement.apply(element);
            List keys = targetList.stream().map(keyOfTarget).collect(Collectors.toList());
            return keys.indexOf(key);
        };
        return Comparator.comparing(indexOfElement);
    }

    public static <T> void retain(Collection<T> coll, Predicate<T> filter) {
        ArrayUtil.remove(coll, filter.negate());
    }

    public static <T> Optional<Set<T>> toOptionalSet(T ... ids) {
        if (ids == null || ids.length == 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(Stream.of(ids).collect(Collectors.toSet()));
    }

    public static <T, C> void findAnyBiSameStatusThenConsumer(List<T> list, Function<T, C> compareElement, BiFunction<C, C, Boolean> statusComparer, BiConsumer<T, T> sameConsumer) {
        ArrayUtil.findAnyBiSameStatus(list, compareElement, statusComparer).ifPresent(entry -> sameConsumer.accept(entry.getKey(), entry.getValue()));
    }

    public static <T, C> Optional<Map.Entry<T, T>> findAnyBiSameStatus(Function<T, C> compareElement, BiFunction<C, C, Boolean> statusComparer, T ... array) {
        return ArrayUtil.findAnyBiSameStatus(Stream.of(array).collect(Collectors.toList()), compareElement, statusComparer);
    }

    public static <T, C> Optional<Map.Entry<T, T>> findAnyBiSameStatus(List<T> list, Function<T, C> compareElement, BiFunction<C, C, Boolean> statusComparer) {
        if (list.size() > 2) {
            Object first = list.get(0);
            List otherItems = list.subList(1, list.size());
            return otherItems.stream().map(item -> ArrayUtil.findAnyBiSameStatus(compareElement, statusComparer, first, item)).filter(Optional::isPresent).findFirst().orElseGet(() -> ArrayUtil.findAnyBiSameStatus(otherItems, compareElement, statusComparer));
        }
        if (list.size() == 2) {
            C secondCompare;
            C firstCompare = compareElement.apply(list.get(0));
            if (statusComparer.apply(firstCompare, secondCompare = compareElement.apply(list.get(1))).booleanValue()) {
                return Optional.of(VarUtil.createEntry(list.get(0), list.get(1)));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

