/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.bean;

import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.mini.framework.util.string.GsonUtil;
import com.mini.framework.util.string.RegexUtil;
import java.io.Serializable;

public interface BeanSerializable
extends Serializable {
    public static final String gsonSerializeTemp = "serializer:Gson,Type:%s,serialize:%s";
    public static final String gsondeserializeRegexTemp = "serializer:Gson,Type:(.*),serialize:(.*)";

    default public String serialize() {
        String serialize = GsonUtil.buildMilliSecondDateGson().toJson((Object)this);
        String type = this.getClass().getTypeName();
        return String.format(gsonSerializeTemp, type, serialize);
    }

    default public BeanSerializable deserialize(String serializeStr) throws ClassNotFoundException {
        String[] serializeArr = RegexUtil.getMatch(gsondeserializeRegexTemp, serializeStr, 1, 2);
        if (serializeArr == null) {
            throw new HandleEnDeCodeException("\u5e8f\u5217\u5316\u5b57\u6bb5Gson\u683c\u5f0f\u4e0d\u6b63\u786e:%s", new Object[]{serializeStr});
        }
        Class<?> classOfT = Class.forName(serializeArr[0]);
        return (BeanSerializable)GsonUtil.buildMilliSecondDateGson().fromJson(serializeArr[1], classOfT);
    }

    public static class SimpleImpl
    implements BeanSerializable {
        private static final long serialVersionUID = -3090800397347962318L;
    }
}

