/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.bean;

import com.mini.framework.core.exception.HandleException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BeanUtil {
    public static List<Field> getAllField(Object bean) {
        ArrayList<Field> allField = new ArrayList<Field>();
        Class<?> tempClass = bean.getClass();
        do {
            Field[] fields = tempClass.getDeclaredFields();
            allField.addAll(Arrays.asList(fields));
        } while ((tempClass = tempClass.getSuperclass()) != null && tempClass != Object.class);
        return allField;
    }

    public static <T> Map<String, Object> beanToMap(T source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        List<Field> sourceFiled = BeanUtil.getAllField(source);
        for (Field field : sourceFiled) {
            field.setAccessible(true);
            try {
                result.put(field.getName(), field.get(source));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new HandleException((Throwable)e, "\u5728\u53d6\u7c7b%s\u7684\u5c5e\u6027%s\u65f6\u51fa\u9519", new Object[]{source.getClass(), field});
            }
        }
        return result;
    }
}

