/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.cache;

import com.mini.framework.util.asserts.AssertUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class HoldFunction<T, R>
implements Function<T, R> {
    private Map<T, R> cacheMapper = new HashMap<T, R>();
    private Set<T> executeFlag = new HashSet<T>();
    private Function<T, R> function = null;

    private HoldFunction(Function<T, R> function) {
        this.function = function;
    }

    public static <T, R> HoldFunction<T, R> create(Function<T, R> function) {
        AssertUtil.assertMethodRequire(function, "function");
        return new HoldFunction<T, R>(function);
    }

    @Override
    public R apply(T t) {
        if (this.executeFlag.contains(t)) {
            return this.cacheMapper.get(t);
        }
        this.executeFlag.add(t);
        R r = this.function.apply(t);
        this.cacheMapper.put(t, r);
        return r;
    }

    public void clear() {
        this.executeFlag.clear();
        this.cacheMapper.clear();
    }
}

