/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.cache;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.status.Status;
import java.util.Date;
import java.util.function.Supplier;

public class ObjectVariableCache<O> {
    private final long expireMillis;
    private final CustomException unFoundException;
    private final Supplier<O> getter;
    private Date expireDate;
    private volatile O variable;

    private ObjectVariableCache(Supplier<O> getter, long expireMillis, CustomException unFoundException) {
        this.getter = getter;
        this.expireMillis = expireMillis;
        this.unFoundException = unFoundException;
    }

    public static <T> ObjectVariableCache<T> createInstance(long expireMillis, Supplier<T> getter) {
        return ObjectVariableCache.createInstance(expireMillis, getter, (CustomException)new ServerException("\u6ca1\u6709\u5b9a\u4e49\u51fa\u9519\u65f6\u7684\u9519\u8bef", new Object[0]));
    }

    public static <T> ObjectVariableCache<T> createInstance(long expireMillis, Supplier<T> getter, CustomException unFoundException) {
        if (unFoundException == null) {
            throw new ServerException(Status.Server.fatalBug, "\u5fc5\u987b\u5b9a\u4e49\u5f02\u5e38", new Object[0]);
        }
        return new ObjectVariableCache<T>(getter, expireMillis, unFoundException);
    }

    public synchronized O getVariableSync() {
        return this.getVariable();
    }

    public O getVariable() {
        Date now = new Date();
        if (this.expireDate != null && this.expireDate.after(now) && this.variable != null) {
            return this.variable;
        }
        O newVariable = this.getter.get();
        if (newVariable == null) {
            throw this.unFoundException;
        }
        this.variable = newVariable;
        this.expireDate = new Date(System.currentTimeMillis() + this.expireMillis);
        return newVariable;
    }
}

