/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.cache.annotation.springboot2;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.cache.annotation.springboot2.AbstractRedisCacheSupport;
import com.mini.framework.util.cache.annotation.springboot2.CustomCacheKeyPrefix;
import com.mini.framework.util.cache.annotation.springboot2.MultiSiteCustomCacheKeyPrefix;
import com.mini.framework.util.cache.annotation.springboot2.RedisConnectConfig;
import com.mini.framework.util.paas.SiteIdReader;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

public class AbstractMultiSiteRedisCacheSupport<S>
extends AbstractRedisCacheSupport {
    private SiteIdReader<S> siteIdReader;

    public AbstractMultiSiteRedisCacheSupport(JedisConnectionFactory jedisConnectionFactory, String cacheNamespace, SiteIdReader<S> siteIdReader) {
        this.siteIdReader = siteIdReader;
        AssertUtil.assertNotFatal(this.siteIdReader != null, "siteIdReader\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        this.afterInit(jedisConnectionFactory, cacheNamespace);
    }

    public AbstractMultiSiteRedisCacheSupport(RedisConnectConfig redisConnectConfig, String cacheNamespace, SiteIdReader<S> siteIdReader) {
        this(AbstractMultiSiteRedisCacheSupport.createJedisConnectionFactory(redisConnectConfig.getHost(), redisConnectConfig.getPort(), redisConnectConfig.getPassword(), redisConnectConfig.getDatabase(), redisConnectConfig.getTimeout()), cacheNamespace, siteIdReader);
    }

    @Override
    protected CustomCacheKeyPrefix createKeyPrefix(String cacheNamespace) {
        return new MultiSiteCustomCacheKeyPrefix<S>(cacheNamespace, this.siteIdReader);
    }
}

