/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.code;

import com.mini.framework.util.asserts.AssertUtil;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DevCodeDescPoint {
    private String code;
    private String desc;
    private String line;
    public static final String lineRegex = "#\u6807\u51c6\u540d\u8bcd\u8bf4\u660e@(.*):(.*);";

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public DevCodeDescPoint() {
    }

    public DevCodeDescPoint(String code, String desc, String line) {
        this.code = code;
        this.desc = desc;
        this.line = line;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static Optional<DevCodeDescPoint> fromLine(String line) {
        AssertUtil.assertMethodRequire(line, "line");
        Matcher match = Pattern.compile(lineRegex).matcher(line);
        if (match.find()) {
            String code = match.group(1);
            String desc = match.group(2);
            return Optional.of(new DevCodeDescPoint(code, desc, line));
        }
        return Optional.empty();
    }
}

