/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.code;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.code.MapperCodeUtil;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PartitionCodeUtil {
    public final int guessDisturbTime;
    public final int partitionNumber;
    public final MapperCodeUtil mapperCodeUtil;
    private Integer useMax;

    private PartitionCodeUtil(int guessDisturbTime, int partitionNumber, MapperCodeUtil mapperCodeUtil) {
        this.guessDisturbTime = guessDisturbTime;
        this.partitionNumber = partitionNumber;
        this.mapperCodeUtil = mapperCodeUtil;
        this.init();
    }

    public static PartitionCodeUtil create(int guessDisturbTime, int partitionNumber, int targetLength, String charItems, int useRadix, int repeatDegree, long salt) {
        return new PartitionCodeUtil(guessDisturbTime, partitionNumber, MapperCodeUtil.create(targetLength, charItems, useRadix, repeatDegree, salt));
    }

    @Deprecated
    public static PartitionCodeUtil createSimpleBinaray(int guessDisturbTime, int partitionNumber, int targetLength, int salt) {
        return PartitionCodeUtil.createSimpleBinary(guessDisturbTime, partitionNumber, targetLength, salt);
    }

    public static PartitionCodeUtil createSimpleBinary(int guessDisturbTime, int partitionNumber, int targetLength, int salt) {
        return new PartitionCodeUtil(guessDisturbTime, partitionNumber, MapperCodeUtil.createSimpleBinary(targetLength, salt));
    }

    private void init() {
        long useMaxLong = this.mapperCodeUtil.getUseMax() / (long)this.guessDisturbTime / (long)this.partitionNumber;
        AssertUtil.assertNoBadReq(useMaxLong <= Integer.MAX_VALUE, Status.BadReq.hitLimit, "useMaxLong:[%s]\u8d85\u8fc7integer\u6700\u5927\u9650\u5236", useMaxLong);
        this.useMax = (int)useMaxLong;
    }

    public String encode(int partitionIndex, int input) {
        AssertUtil.assertNoBadReq(partitionIndex >= 0, Status.BadReq.illParam, "partitionIndex:[%s]\u5fc5\u987b\u5927\u4e8e0", this.partitionNumber);
        AssertUtil.assertNoBadReq(partitionIndex < this.partitionNumber, Status.BadReq.illParam, "partitionIndex:[%s]\u5fc5\u987b\u5c0f\u4e8epartitionNumber:[%s]", partitionIndex, this.partitionNumber);
        AssertUtil.assertNoBadReq(input < this.useMax, Status.BadReq.illParam, "input:[%s]\u5fc5\u987b\u5c0f\u4e8euseMax:[%s]", input, this.useMax);
        long realInput = (long)input * (long)this.partitionNumber + (long)partitionIndex;
        return this.mapperCodeUtil.encode(realInput *= (long)this.guessDisturbTime);
    }

    public PartitionCode decode(String text) {
        long result = this.mapperCodeUtil.decode(text);
        AssertUtil.assertNoBadReq(result % (long)this.guessDisturbTime == 0L, Status.BadReq.illParam, "\u7f16\u7801:[%s]\u4e0d\u662f\u6b63\u5e38\u7684\u7f16\u7801", text);
        long index = (result /= (long)this.guessDisturbTime) / (long)this.partitionNumber;
        long partition = result % (long)this.partitionNumber;
        return PartitionCode.createByIndexValue((int)partition, (int)index);
    }

    public Integer getUseMax() {
        return this.useMax;
    }

    public static class PartitionCode {
        private Integer partition;
        private String code;
        private Integer index;

        private PartitionCode(Integer partition, String code, Integer index) {
            this.partition = partition;
            this.code = code;
            this.index = index;
        }

        public static PartitionCode createByCode(String code) {
            return new PartitionCode(null, code, null);
        }

        public static PartitionCode createByIndexValue(int partition, int index) {
            return new PartitionCode(partition, null, index);
        }

        public PartitionCode encode(PartitionCodeUtil util) {
            this.code = util.encode(this.partition, this.index);
            return this;
        }

        public PartitionCode decode(PartitionCodeUtil util) {
            PartitionCode result = util.decode(this.code);
            this.index = result.index;
            this.partition = result.partition;
            return this;
        }

        public Integer getPartition() {
            return this.partition;
        }

        public String getCode() {
            return this.code;
        }

        public Integer getIndex() {
            return this.index;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

