/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.colony;

import com.mini.framework.util.colony.DelayLockHelper;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonClient;
import org.redisson.core.RLock;

public class RedissonIncDelayLockHelper
implements DelayLockHelper {
    private RedissonClient redissonClient;
    private String prefix;
    private String keySplit = ":";

    public RedissonIncDelayLockHelper(RedissonClient redissonClient, String prefix) {
        this.redissonClient = redissonClient;
        this.prefix = prefix;
    }

    @Override
    public boolean getLock(int delay, String key) {
        key = this.createKey(this.prefix, key);
        RLock lock = this.redissonClient.getLock(key);
        try {
            return lock.tryLock(0L, (long)delay, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void releaseLock(String key) {
        key = this.createKey(this.prefix, key);
        RLock lock = this.redissonClient.getLock(key);
        lock.unlock();
    }

    @Override
    public String createKey(String ... params) {
        return String.join((CharSequence)this.keySplit, params);
    }
}

