/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.date;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.asserts.Require;
import com.mini.framework.util.date.DateShortString;
import com.mini.framework.util.date.DateStringFormat;
import com.mini.framework.util.date.TimeSection;
import com.mini.framework.util.date.TimeSectionType;
import com.mini.framework.util.date.bean.RelativeDate;
import com.mini.framework.util.date.bean.RelativeDateAliasScheme;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil {
    private static final long oneWeekFirst = 321465600000L;

    public static List<TimeSection> createFence(TimeSectionType timeUnit, Date begin, Date end) {
        Date minDate = DateUtil.getCleanedDateUnit(timeUnit, begin);
        Date oneFence = new Date(minDate.getTime());
        ArrayList<TimeSection> TimeSectionDtos = new ArrayList<TimeSection>();
        while (oneFence.compareTo(end) <= 0) {
            TimeSection TimeSectionDto = new TimeSection(timeUnit, oneFence);
            TimeSectionDtos.add(TimeSectionDto);
            oneFence = DateUtil.addTimeUnit(timeUnit, oneFence, 1);
        }
        return TimeSectionDtos;
    }

    public static boolean isDateUnitPoint(TimeSectionType timeSectionType, Date date) {
        AssertUtil.assertMethodRequire(date, "date");
        AssertUtil.assertMethodRequire(timeSectionType, "timeSectionType");
        Date newDate = DateUtil.getCleanedDateUnit(timeSectionType, date);
        return newDate.getTime() == date.getTime();
    }

    public static Date getCleanedTauchDateUnit(TimeSectionType timeSectionType, Date oldDate) {
        Date newDate = DateUtil.getCleanedDateUnit(timeSectionType, oldDate);
        if (newDate.compareTo(oldDate) < 0) {
            newDate = DateUtil.addTimeUnit(timeSectionType, newDate, 1);
        }
        return newDate;
    }

    public static long getOverflowTime(TimeSectionType timeSectionType, Date point) {
        AssertUtil.assertMethodRequire(point, "point");
        AssertUtil.assertMethodRequire(timeSectionType, "timeSectionType");
        return point.getTime() - DateUtil.getCleanedDateUnit(TimeSectionType.day, point).getTime();
    }

    public static Date getCleanedDateUnit(TimeSectionType timeSectionType, Date oldDate, int offset) {
        Date cleanedDate = DateUtil.getCleanedDateUnit(timeSectionType, oldDate);
        return DateUtil.addTimeUnit(timeSectionType, cleanedDate, offset);
    }

    public static Date getCleanedDateUnit(TimeSectionType timeSectionType, Date oldDate) {
        AssertUtil.assertMethodRequire(timeSectionType, "timeSectionType");
        AssertUtil.assertMethodRequire(oldDate, "oldDate");
        Date cleanedDate = oldDate;
        cleanedDate = DateUtils.setMilliseconds((Date)cleanedDate, (int)0);
        cleanedDate = DateUtils.setSeconds((Date)cleanedDate, (int)0);
        cleanedDate = DateUtils.setMinutes((Date)cleanedDate, (int)0);
        switch (timeSectionType) {
            case all: {
                cleanedDate = new Date(0L);
                break;
            }
            case week: {
                cleanedDate = DateUtil.setWeek(cleanedDate, 0);
                break;
            }
            case year: {
                cleanedDate = DateUtils.setMonths((Date)cleanedDate, (int)0);
            }
            case season: {
                int seasonMonth = DateUtil.seasonIndex(cleanedDate) * 3;
                cleanedDate = DateUtils.setDays((Date)cleanedDate, (int)1);
                cleanedDate = DateUtils.setMonths((Date)cleanedDate, (int)seasonMonth);
            }
            case month: {
                cleanedDate = DateUtils.setDays((Date)cleanedDate, (int)1);
            }
            case day: {
                cleanedDate = DateUtils.setHours((Date)cleanedDate, (int)0);
            }
            case hour: {
                break;
            }
            default: {
                throw new BadReqException(Status.BadReq.illParam, "\u65e5\u671f%s\u65e0\u6548\u5fc5\u987b\u5728%s\u4e2d\u9009", new Object[]{timeSectionType, "[hour,day,week,month,year]"});
            }
        }
        return cleanedDate;
    }

    public static Date setWeek(Date date, int weekIndex) {
        AssertUtil.assertNoBadReq(weekIndex, Require.between, "\u65e5\u671f\u5fc5\u987b\u4ecb\u4e8e[%s,%s)", 0, 7);
        long day = 86400000L;
        long time = date.getTime();
        long clear = (time - 321465600000L) % (day * 7L);
        time -= clear;
        date = new Date(time += day * (long)weekIndex);
        return date;
    }

    public static Date addTimeUnit(TimeSectionType timeSectionType, Date oldDate, int amount) {
        Date newDate = null;
        switch (timeSectionType) {
            case hour: {
                newDate = DateUtils.addHours((Date)oldDate, (int)amount);
                break;
            }
            case day: {
                newDate = DateUtils.addDays((Date)oldDate, (int)amount);
                break;
            }
            case week: {
                newDate = DateUtils.addWeeks((Date)oldDate, (int)amount);
                break;
            }
            case month: {
                newDate = DateUtils.addMonths((Date)oldDate, (int)amount);
                break;
            }
            case season: {
                newDate = DateUtils.addMonths((Date)oldDate, (int)(amount * 3));
                break;
            }
            case year: {
                newDate = DateUtils.addYears((Date)oldDate, (int)amount);
                break;
            }
            default: {
                throw new BadReqException(Status.BadReq.illParam, "\u65e5\u671f%s\u65e0\u6548\u5fc5\u987b\u5728%s\u4e2d\u9009", new Object[]{timeSectionType, "[hour,day,week,month,season,year]"});
            }
        }
        return newDate;
    }

    public static Date currentFullPoint(int seconds) {
        return DateUtil.dateFullPoint(new Date(), seconds);
    }

    public static Date dateFullPoint(Date date, int seconds) {
        AssertUtil.assertMethodRequire(date, "date");
        long currentTime = date.getTime();
        return new Date(currentTime - currentTime % (long)(seconds * 1000));
    }

    public static TimeSection currentTimeSection(TimeSectionType timeSectionType) {
        return DateUtil.createTimeSection(new Date(), timeSectionType);
    }

    public static TimeSection createTimeSection(Date date, TimeSectionType timeSectionType) {
        Date sectionPoint = DateUtil.getCleanedDateUnit(timeSectionType, date);
        return new TimeSection(timeSectionType, sectionPoint);
    }

    public static String toSimpleDateTime(Date date) {
        return DateFormatUtils.format((Date)date, (String)"MM-dd HH:mm");
    }

    public static String toMilSecondsString(Date date) {
        return DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static String toSecondsString(Date date) {
        return DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String toSecondsNumeric(Date date) {
        return DateFormatUtils.format((Date)date, (String)"yyyyMMddHHmmss");
    }

    public static String toMilSecondsNumeric(Date date) {
        return DateFormatUtils.format((Date)date, (String)"yyyyMMddHHmmssSSS");
    }

    public static String toDateString(DateStringFormat dsf) {
        return DateUtil.toDateString(dsf, new Date());
    }

    public static String toDateString(DateStringFormat dsf, Date date) {
        dsf.getDatePattern();
        String dateString = DateFormatUtils.format((Date)date, (String)dsf.getDatePattern());
        String string = String.format(dsf.getStringPattern(), dateString);
        return string;
    }

    public static String toDateSectionEnglishShort(Date date, TimeSectionType type) {
        TimeSection scetion = DateUtil.createTimeSection(date, type);
        return DateUtil.toDateSectionEnglishShort(scetion);
    }

    public static String toDateSectionEnglishShort(TimeSection timeSection) {
        AssertUtil.assertMethodRequire(timeSection, "timeSection");
        timeSection.validate();
        HashMap<TimeSectionType, String> sectionFormat = new HashMap<TimeSectionType, String>();
        sectionFormat.put(TimeSectionType.year, "yyyy");
        sectionFormat.put(TimeSectionType.month, "yyyy-MM");
        sectionFormat.put(TimeSectionType.day, "MM-dd");
        sectionFormat.put(TimeSectionType.hour, "MM-dd HH");
        String format = (String)sectionFormat.get(timeSection.getTimeUnit());
        AssertUtil.assertSupport(format != null, "\u4e0d\u652f\u6301%s\u7c7b\u578b\u7684\u65f6\u95f4\u7b80\u5199", timeSection.getTimeUnit());
        return DateFormatUtils.format((Date)timeSection.getSectionPoint(), (String)format);
    }

    public static <T> List<DateShortString> toDateSectionEnglishShort(Collection<T> list, Function<T, Date> showDate, TimeSectionType timeUnit) {
        return list.stream().map(showDate).map(date -> new DateShortString((Date)date, DateUtil.toDateSectionEnglishShort(date, timeUnit))).collect(Collectors.toList());
    }

    public static <T> List<DateShortString> toDateSectionChinaDateShort(Collection<T> list, Function<T, Date> showDate) {
        return list.stream().map(showDate).map(date -> new DateShortString((Date)date, DateUtil.toDateSectionChinaDateShort(date))).collect(Collectors.toList());
    }

    public static String toDateSectionChinaDateShort(Date date) {
        return DateFormatUtils.format((Date)date, (String)"yyyy\u5e74MM\u6708dd\u65e5");
    }

    public static String simpleWeekDateRetainKeyPoint(Date date, TimeSectionType minType) {
        AssertUtil.assertMethodRequire(minType, "minType");
        AssertUtil.assertMethodRequire(date, "date");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(2);
        int index = calendar.get(3);
        Date weekDate = DateUtil.addTimeUnit(TimeSectionType.week, date, 1);
        String year = index == 1 ? DateFormatUtils.format((Date)weekDate, (String)"yyyy\u5e74") : "";
        return String.format("%s\u7b2c%s\u5468", year, index);
    }

    public static String simpleDateRetainKeyPoint(Date date, TimeSectionType minType) {
        Map.Entry timeType;
        AssertUtil.assertMethodRequire(minType, "minType");
        AssertUtil.assertMethodRequire(date, "date");
        if (minType.equals(TimeSectionType.week)) {
            return DateUtil.simpleWeekDateRetainKeyPoint(date, minType);
        }
        if (minType.equals(TimeSectionType.season)) {
            return "TODO";
        }
        LinkedHashMap<TimeSectionType, Map> timeTypeRange = new LinkedHashMap<TimeSectionType, Map>();
        BiFunction<String, String, Map> ss = (k, v) -> {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put((String)k, (String)v);
            return m;
        };
        timeTypeRange.put(TimeSectionType.hour, ss.apply("HH\u65f6", "00\u65f6"));
        timeTypeRange.put(TimeSectionType.day, ss.apply("dd\u65e5", "01\u65e5"));
        timeTypeRange.put(TimeSectionType.month, ss.apply("MM\u6708", "01\u6708"));
        timeTypeRange.put(TimeSectionType.year, ss.apply("yyyy\u5e74", "3000\u5e74"));
        AssertUtil.assertSupport(timeTypeRange.containsKey(minType), "minType:[%s]\u5fc5\u987b\u5728%s\u5185", minType, timeTypeRange.keySet());
        Iterator rit = timeTypeRange.entrySet().iterator();
        while (rit.hasNext() && !((TimeSectionType)(timeType = rit.next()).getKey()).equals(minType)) {
            rit.remove();
        }
        Function<TimeSectionType, Map> typeToPair = type -> (Map)timeTypeRange.get(type);
        Function<Map, String> pairToPattern = pair -> (String)((Map.Entry)pair.entrySet().stream().findFirst().get()).getKey();
        Function<Map, String> pairToPoint = pair -> (String)((Map.Entry)pair.entrySet().stream().findFirst().get()).getValue();
        Function<String, String> patternToResult = p -> DateFormatUtils.format((Date)date, (String)p);
        String result = "";
        boolean requireMore = true;
        String preResult = typeToPair.andThen(pairToPattern).andThen(patternToResult).apply(minType);
        String prePoint = typeToPair.andThen(pairToPoint).apply(minType);
        Iterator it = timeTypeRange.entrySet().iterator();
        while (it.hasNext() && requireMore) {
            Map.Entry entry = it.next();
            preResult = typeToPair.andThen(pairToPattern).andThen(patternToResult).apply((TimeSectionType)entry.getKey());
            prePoint = typeToPair.andThen(pairToPoint).apply((TimeSectionType)entry.getKey());
            result = preResult + result;
            requireMore = prePoint.equals(preResult);
        }
        return result;
    }

    public static int seasonIndex(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int monthIndex = calendar.get(2);
        int seasonMonth = monthIndex / 3;
        return seasonMonth;
    }

    public static String indexSeasonNameQsort(Date date) {
        String[] seasonNames = new String[]{"Q1\u6625\u5b63", "Q2\u590f\u5b63", "Q3\u79cb\u5b63", "Q4\u51ac\u5b63"};
        int seasonIndex = DateUtil.seasonIndex(date);
        return seasonNames[seasonIndex];
    }

    public static String indexDayOfWeekSimpleName(Date date) {
        String englishName = DateFormatUtils.format((Date)date, (String)"E");
        return englishName;
    }

    public static int indexWeekOfYear(Date date) {
        String weekIndexName = DateFormatUtils.format((Date)date, (String)"w");
        return Integer.parseInt(weekIndexName);
    }

    public static int indexDayOfMonth(Date date) {
        String dayIndexName = DateFormatUtils.format((Date)date, (String)"d");
        return Integer.parseInt(dayIndexName);
    }

    public static int indexWeekOfMonth(Date date) {
        if (DateUtil.indexDayOfMonth(date = new Date(date.getTime())) < 15) {
            Date nextWeek = DateUtil.addTimeUnit(TimeSectionType.week, date, 1);
            int nextWeekDayIndex = DateUtil.indexDayOfMonth(DateUtil.setWeek(nextWeek, 0));
            return nextWeekDayIndex / 7;
        }
        Date nextWeek = DateUtil.addTimeUnit(TimeSectionType.week, date, -1);
        int nextWeekDayIndex = DateUtil.indexDayOfMonth(DateUtil.setWeek(nextWeek, 0));
        return nextWeekDayIndex / 7 + 2;
    }

    public static List<RelativeDate> relativeNow1(Stream<Date> actualDates) {
        return RelativeDate.countRelatives(RelativeDateAliasScheme.nowScheme1, new Date(), actualDates);
    }

    public static List<RelativeDate> relativeNow1(List<Date> actualDates) {
        return RelativeDate.countRelatives(RelativeDateAliasScheme.nowScheme1, new Date(), actualDates.stream());
    }

    public static <D> List<RelativeDate> relativeNow1(List<D> actualDates, Function<D, Date> dateGetter) {
        return RelativeDate.countRelatives(RelativeDateAliasScheme.nowScheme1, new Date(), actualDates.stream().map(dateGetter));
    }
}

