/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.date;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public enum TimeSectionType implements Comparator<TimeSectionType>
{
    hour,
    day,
    week,
    month,
    season,
    year,
    all;

    private static Map<TimeSectionType, Integer> typeIndex;

    @Override
    public int compare(TimeSectionType o1, TimeSectionType o2) {
        return typeIndex.get(o1).compareTo(typeIndex.get(o2));
    }

    public List<TimeSectionType> typesFormThis() {
        return typeIndex.keySet().stream().filter(type -> type.compareTo(this) >= 0).collect(Collectors.toList());
    }

    private static Map<TimeSectionType, Integer> createTypeIndex() {
        ConcurrentHashMap<TimeSectionType, Integer> typeIndex = new ConcurrentHashMap<TimeSectionType, Integer>();
        typeIndex.put(hour, 1);
        typeIndex.put(day, 2);
        typeIndex.put(week, 3);
        typeIndex.put(month, 4);
        typeIndex.put(season, 5);
        typeIndex.put(year, 6);
        typeIndex.put(all, 7);
        return typeIndex;
    }

    static {
        typeIndex = TimeSectionType.createTypeIndex();
    }
}

