/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.date.bean;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.type.EnumTypeShower;
import java.util.Date;
import java.util.Map;

public enum RelativeDateAliasScheme implements EnumTypeShower<RelativeDateAliasScheme>
{
    nowScheme1("\u76f8\u5bf9\u73b0\u5728\u65f6\u95f41", "\u4e0e\u73b0\u5728\u8fd9\u4e2a\u65f6\u95f4\u7684\u76f8\u5bf9\u65f6\u95f4TODO \u540e\u9762\u8fd8\u8981\u52a0\u4e0a\u8be6\u7ec6\u7684\u8bf4\u660e");

    private static int secondsMilli;
    private static int minuteMilli;
    private static int hourMilli;
    private static int dayMilli;
    private static int weekMilli;
    private static int monthMilli;
    private static long yearMilli;
    private int yearAccuracyMin = 2;
    private int monthAccuracyMin = 2;
    private int weekAccuracyMin = 2;
    private int dayAccuracyMin = 2;
    private int hourAccuracyMin = 2;
    private int minuteAccuracyMin = 2;
    private int secondsAccuracyMin = 2;
    private String title;
    private String desc;

    private RelativeDateAliasScheme(String title, String desc) {
        this.title = title;
        this.desc = desc;
    }

    public String countRelativeName(Date selfDate, Date targetDate) {
        AssertUtil.assertMethodRequire(selfDate, "selfDate");
        AssertUtil.assertMethodRequire(targetDate, "targetDate");
        return this.countRelativeName(selfDate.getTime() - targetDate.getTime());
    }

    public String countRelativeName(Long intervalTime) {
        String suffix = intervalTime > 0L ? "\u540e" : "\u524d";
        if ((intervalTime = Long.valueOf(Math.abs(intervalTime))) > (long)this.yearAccuracyMin * yearMilli) {
            return (long)this.yearAccuracyMin / yearMilli + "\u5e74" + suffix;
        }
        if (intervalTime > (long)(this.monthAccuracyMin * monthMilli)) {
            return this.monthAccuracyMin / monthMilli + "\u6708" + suffix;
        }
        if (intervalTime > (long)(this.dayAccuracyMin * dayMilli)) {
            return this.dayAccuracyMin / dayMilli + "\u5929" + suffix;
        }
        if (intervalTime > (long)(this.weekAccuracyMin * weekMilli)) {
            return this.weekAccuracyMin / weekMilli + "\u661f\u671f" + suffix;
        }
        if (intervalTime > (long)(this.hourAccuracyMin * hourMilli)) {
            return this.hourAccuracyMin / hourMilli + "\u5c0f\u65f6" + suffix;
        }
        if (intervalTime > (long)(this.minuteAccuracyMin * minuteMilli)) {
            return this.minuteAccuracyMin / minuteMilli + "\u5206\u949f" + suffix;
        }
        if (intervalTime > (long)(this.secondsAccuracyMin * secondsMilli)) {
            return this.secondsAccuracyMin / secondsMilli + "\u79d2\u949f" + suffix;
        }
        return "\u521a\u521a";
    }

    @Override
    public void fillFieldToMap(Map<String, Object> map) {
        map.put("title", this.title);
        map.put("desc", this.desc);
    }

    static {
        secondsMilli = 1000;
        minuteMilli = secondsMilli * 60;
        hourMilli = secondsMilli * 60;
        dayMilli = hourMilli * 24;
        weekMilli = dayMilli * 7;
        monthMilli = dayMilli * 30;
        yearMilli = monthMilli * 12;
    }
}

