/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.export;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.export.protocol.DefaultExcelCellContentSupplier;
import com.mini.framework.util.export.protocol.ExcelCellContentSupplier;
import com.mini.framework.util.export.protocol.branch.SwitchCases;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.MessageFormat;
import java.util.function.Function;
import java.util.stream.Stream;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
public @interface ExcelColumnDeclare {
    public int sorter() default 100;

    public boolean skip() default false;

    public String title();

    public String dataPath();

    public String defaultValue() default "";

    public Class<? extends ExcelCellContentSupplier> contentSupplier() default DefaultExcelCellContentSupplier.class;

    public String[] formatsAfterSupplier() default {"{0}"};

    public SwitchCases firstSwitchCaseReplace() default @SwitchCases(nameCases={});

    public static interface Support {
        public static String contentFromOrigin(ExcelColumnDeclare declare, String origin) {
            AssertUtil.assertMethodRequire(origin, "origin");
            Class<? extends ExcelCellContentSupplier> contentSupplierClass = declare.contentSupplier();
            SwitchCases switchCaseReplace = declare.firstSwitchCaseReplace();
            origin = SwitchCases.Support.applyCases(switchCaseReplace, origin);
            ExcelCellContentSupplier columnContentSupplier = ExcelCellContentSupplier.createInstance(contentSupplierClass);
            String content = columnContentSupplier.supplier(origin);
            return Stream.of(declare.formatsAfterSupplier()).reduce(content, (c, e) -> MessageFormat.format(e, c));
        }

        public static Function<String, String> contentSupplierFromOrigin(ExcelColumnDeclare declare) {
            return origin -> Support.contentFromOrigin(declare, origin);
        }
    }
}

