/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.file;

import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.util.cache.HoldSupplier;
import com.mini.framework.util.log.MiniLogLevel;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JarUtil {
    private static Logger logger = LogManager.getLogger(JarUtil.class);
    private static final String springBuildVersionKey = "Implementation-Version";
    private static final String metaInfPath = "META-INF" + File.separator + "MANIFEST.MF";
    private static HoldSupplier<Map<String, String>> metaInfosSupplier = HoldSupplier.create(() -> JarUtil.readCurrentRunJarMetaInfos());

    public static Map<String, String> readprops(String jarFile, String path) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        JarFile jar = null;
        try {
            jar = new JarFile(jarFile);
            JarEntry entry = jar.getJarEntry(path);
            List lines = IOUtils.readLines((InputStream)jar.getInputStream(entry), (String)"utf-8");
            lines.stream().filter(line -> line != null).forEach(line -> {
                String[] keyValue = line.split(": ");
                props.put(keyValue[0], keyValue.length > 1 ? keyValue[1] : null);
            });
        }
        catch (IOException e) {
            try {
                throw new HandleIOException((Throwable)e, "\u5904\u7406jar:[%s]\u6587\u4ef6\u51fa\u9519", new Object[]{jarFile});
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jar);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)jar);
        return props;
    }

    public static Map<String, String> readCurrentRunJarMetaInfos() {
        return JarUtil.readMetaInfos(JarUtil.getCurrentRunJar());
    }

    public static Map<String, String> readMetaInfos(String jarFile) {
        return JarUtil.readprops(jarFile, metaInfPath);
    }

    public static String getCurrentRunJar() {
        String jarPath = JarUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        logger.log(MiniLogLevel.getFrameWorkLog(), "jarPath:", (Object)jarPath);
        jarPath = StringUtils.substringBetween((String)jarPath, (String)":", (String)"!");
        logger.log(MiniLogLevel.getFrameWorkLog(), "filePath:", (Object)jarPath);
        return Optional.of(jarPath).orElseThrow(() -> new UnsupportedException("\u6682\u65f6\u4e0d\u652f\u6301\u627e\u4e0d\u5230\u5f53\u524d\u8fd0\u884c\u7684jar\u540d\u5b57", new Object[0]));
    }

    public static String currentRunJarStringBuildVersion() {
        String version = metaInfosSupplier.get().get(springBuildVersionKey);
        return version;
    }

    public static String currentRunJarStringBuildVersion(int hourAdd) {
        String version = JarUtil.currentRunJarStringBuildVersion();
        if (hourAdd != 0 && version != null) {
            String hour = StringUtils.substringAfterLast((String)version, (String)"-");
            int intHour = Integer.parseInt(hour);
            intHour = (intHour + hourAdd) % 24;
            version = StringUtils.substringBeforeLast((String)version, (String)"-") + "-" + StringUtils.leftPad((String)String.valueOf(intHour), (int)2, (String)"0");
        }
        return version;
    }
}

