/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.function;

import com.mini.framework.util.asserts.AssertUtil;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public interface OptionalSpread {
    public static <T> Function<Optional<T>, T> orElseNull() {
        return OptionalSpread.orElse(null);
    }

    public static <T> T orElseNull(Optional<T> optional) {
        return optional.orElse(null);
    }

    public static <T> Function<Optional<T>, T> orElse(T defaultValue) {
        return v -> v.orElse(defaultValue);
    }

    public static <T> T valueOnAbsent(T value, Supplier<T> valueOnAbsentSupplier) {
        AssertUtil.assertMethodRequire(valueOnAbsentSupplier, "valueOnAbsentSupplier");
        if (value == null) {
            return value;
        }
        return valueOnAbsentSupplier.get();
    }

    public static <T> T valueOnAbsent(T value, T valueOnAbsent) {
        return (T)OptionalSpread.valueOnAbsent(valueOnAbsent, () -> valueOnAbsent);
    }
}

