/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.function;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public interface PredicateSpread<T>
extends Predicate<T> {
    public static <T> Predicate<T> isEqual(T targetRef) {
        return Predicate.isEqual(targetRef);
    }

    public static <T, F> Predicate<T> isEqual(Function<T, F> fieldRef, F targetRef) {
        Predicate predicate = Predicate.isEqual(targetRef);
        return object -> predicate.test(fieldRef.apply(object));
    }

    public static <T> PredicateSpread<T> right() {
        return t -> true;
    }

    public static <T> PredicateSpread<T> incorrect() {
        return t -> false;
    }

    public static <T> PredicateSpread<T> of(Predicate<T> predicate) {
        return predicate::test;
    }

    public static <T> PredicateSpread<T> ofNegate(Predicate<T> predicate) {
        return predicate.negate()::test;
    }

    public static <T> PredicateSpread<T> of(Optional<Boolean> right) {
        return PredicateSpread.of(right.orElse(true));
    }

    public static <T> PredicateSpread<T> of(boolean right) {
        if (right) {
            return PredicateSpread.right();
        }
        return PredicateSpread.incorrect();
    }

    public static <T, F> PredicateSpread<T> nextTest(Function<T, F> nextGetter, Predicate<F> nextTest) {
        return t -> nextTest.test(nextGetter.apply(t));
    }

    public static <T, G> PredicateSpread<T> matchTest(BiFunction<T, G, Boolean> matchFn, G goal) {
        return t -> (Boolean)matchFn.apply(t, goal);
    }

    public static <T, P> PredicateSpread<T> applySecondParam(P secondParam, BiFunction<T, P, Boolean> applySecondParamFn) {
        return t -> (Boolean)applySecondParamFn.apply(t, secondParam);
    }
}

