/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.generic.define;

import com.mini.framework.util.generic.define.OptionalSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OptionalSetDouble
extends OptionalSet<Double> {
    private static final OptionalSetDouble createEmpty() {
        return new OptionalSetDouble();
    }

    public static OptionalSetDouble ofNullable(Collection<Double> collDouble) {
        return collDouble == null ? OptionalSetDouble.createEmpty() : OptionalSetDouble.of(collDouble);
    }

    public static OptionalSetDouble of(Collection<Double> collDouble) {
        OptionalSetDouble set = new OptionalSetDouble();
        Objects.requireNonNull(collDouble, "collDouble\u4e0d\u80fd\u4e3a\u7a7a");
        set.value = new LinkedHashSet<Double>(collDouble);
        return set;
    }

    public static OptionalSetDouble ofNullable(Double ... ts) {
        return ts == null ? OptionalSetDouble.createEmpty() : OptionalSetDouble.of(ts);
    }

    public static OptionalSetDouble of(Double ... ts) {
        return OptionalSetDouble.of(Stream.of(ts).collect(Collectors.toSet()));
    }

    public static OptionalSetDouble ofNullable(String arr) {
        return arr == null ? OptionalSetDouble.createEmpty() : OptionalSetDouble.of(arr);
    }

    public static OptionalSetDouble of(String arr) {
        String[] Doubles = arr.split(",");
        List<Double> list = Stream.of(arr.split(",")).map(Double::parseDouble).collect(Collectors.toList());
        return OptionalSetDouble.of(list);
    }

    public Optional<Set<Double>> out() {
        return this.out(false);
    }

    public Optional<Set<Double>> outNotZero() {
        return this.out(true);
    }

    public Optional<Set<Double>> out(boolean zeroAsNull) {
        if (zeroAsNull && this.value != null && this.value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.value);
    }

    public String toString() {
        return this.out().toString();
    }
}

