/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.generic.define;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SetBean<B> {
    private final Set<B> value;

    private SetBean(Set<B> value) {
        this.value = value;
    }

    public static <B> SetBean<B> of(Collection<B> coll) {
        HashSet<B> beans = new HashSet<B>(coll);
        return new SetBean<B>(beans);
    }

    public static <I, B> SetBean<B> of(Function<I, B> beanGetter, Collection<I> coll) {
        Set beans = coll.stream().map(beanGetter).collect(Collectors.toSet());
        return new SetBean(beans);
    }

    public static <B> SetBean<B> of(B ... beans) {
        Objects.requireNonNull(beans, "beans \u4e0d\u80fd\u4e3a\u7a7a");
        HashSet<B> set = new HashSet<B>(Arrays.asList(beans));
        return new SetBean<B>(set);
    }

    public static <B> SetBean<B> ofNullable(B[] beansNullable) {
        if (beansNullable == null) {
            return new SetBean(new HashSet());
        }
        return SetBean.of(beansNullable);
    }

    public <O> SetBean<O> map(Function<B, O> mapper) {
        Set collect = this.value.stream().map(mapper).collect(Collectors.toSet());
        return new SetBean(collect);
    }

    public Set<B> out() {
        return new HashSet<B>(this.value);
    }

    public boolean isEmpty() {
        return this.value == null || this.value.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean ifEmpty(Consumer<Set<B>> consumer) {
        if (this.isEmpty()) {
            consumer.accept(this.value);
            return true;
        }
        return false;
    }
}

