/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.http.linked;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.Header;

public class HttpHeaders {
    private List<Entry> headers = new ArrayList<Entry>();

    public HttpHeaders(Header[] headers) {
        for (Header header : headers) {
            this.headers.add(new Entry(header.getName(), header.getValue()));
        }
    }

    public boolean contain(String name) {
        return this.queryFirst(name).isPresent();
    }

    public Optional<String> queryFirst(String name) {
        return this.query(name).stream().findFirst();
    }

    public List<String> query(String name) {
        return this.headers.stream().filter(header -> header.matchName(name)).map(Entry::getValue).collect(Collectors.toList());
    }

    public static class Entry {
        private String name;
        private String value;

        public Entry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean matchName(String name) {
            return Objects.equals(name, this.name);
        }
    }
}

