/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.log.trace;

import com.mini.framework.util.log.MiniLogLevel;
import com.mini.framework.util.log.trace.LinkTraceFace;
import com.mini.framework.util.log.trace.MapStorager;
import com.mini.framework.util.log.trace.MethodFeatureResolver;
import com.mini.framework.util.log.trace.SimpleMethodFeatureResolver;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MethodFeatureCache {
    private Logger logger = LogManager.getLogger(MethodFeatureCache.class);
    private MapStorager mapStorager;
    private static Map<String, String> featureMapMethod;
    private MethodFeatureResolver methodFeatureResolver = new SimpleMethodFeatureResolver();
    private boolean toCacheFeatureMapMethod;

    public MethodFeatureCache(MapStorager mapStorager) {
        this.mapStorager = mapStorager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadFeature(String feature) {
        if (featureMapMethod == null) {
            return null;
        }
        String traceId = featureMapMethod.get(feature);
        if (traceId == null) {
            Map<String, String> map = featureMapMethod;
            synchronized (map) {
                traceId = featureMapMethod.get(feature);
                if (traceId == null) {
                    traceId = this.register(feature);
                }
            }
        }
        return traceId;
    }

    public String loadFeature(Method method, MethodFeatureResolver methodFeatureResolver) {
        String feature = methodFeatureResolver.resolveFeature(method);
        return this.loadFeature(feature);
    }

    public String loadFeature(Method method) {
        return this.loadFeature(method, this.methodFeatureResolver);
    }

    private String register(String feature) {
        boolean contain = false;
        String traceId = null;
        do {
            int size;
            if (contain = featureMapMethod.containsValue(traceId = String.valueOf(300000 + (size = featureMapMethod.size())))) continue;
            featureMapMethod.put(feature, traceId);
            this.slowCacheFeatureMapMethod();
            break;
        } while (contain);
        return traceId;
    }

    private void slowCacheFeatureMapMethod() {
        final long timeMark = System.currentTimeMillis();
        this.toCacheFeatureMapMethod = true;
        Thread thread = new Thread(){

            @Override
            public void run() {
                block3: {
                    LinkTraceFace.pointSystemQuartz();
                    int delay = 2000 + RandomUtils.nextInt((int)8000);
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        MethodFeatureCache.this.logger.error("\u5ef6\u8fdf\u51fa\u9519", (Throwable)e);
                        if (timeMark + 300L >= System.currentTimeMillis()) break block3;
                        return;
                    }
                }
                if (MethodFeatureCache.this.toCacheFeatureMapMethod) {
                    MethodFeatureCache.this.logger.log(MiniLogLevel.getFrameWorkLog(), "\u7f13\u5b58featureMapMethod\u5230\u6570\u636e\u5e93size:" + featureMapMethod.size());
                    Map<String, String> dbMapStorager = MethodFeatureCache.this.mapStorager.get();
                    ConcurrentHashMap<String, String> temp = new ConcurrentHashMap<String, String>(featureMapMethod.size());
                    temp.putAll(dbMapStorager);
                    temp.putAll(featureMapMethod);
                    featureMapMethod = temp;
                    MethodFeatureCache.this.mapStorager.set(featureMapMethod);
                    MethodFeatureCache.this.toCacheFeatureMapMethod = false;
                }
                LinkTraceFace.clearTrace();
            }
        };
        thread.start();
    }

    public void init() {
        featureMapMethod = new ConcurrentHashMap<String, String>();
        Map<String, String> dbMap = this.mapStorager.get();
        this.logger.log(MiniLogLevel.getFrameWorkLog(), "\u4ecemapStorager\u5f97\u5230\u539f\u6709\u7684method map:" + dbMap);
        if (dbMap != null) {
            featureMapMethod.putAll(dbMap);
        }
        if (this.methodFeatureResolver == null) {
            this.methodFeatureResolver = new SimpleMethodFeatureResolver();
        }
    }

    public Map<String, String> showLinkFeatures() {
        HashMap<String, String> linkFeature = new HashMap<String, String>();
        linkFeature.putAll(featureMapMethod);
        return linkFeature;
    }
}

