/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.log.trace;

import com.mini.framework.util.log.trace.LinkTraceFace;
import com.mini.framework.util.log.trace.MethodFeatureCache;
import com.mini.framework.util.log.trace.MethodFeatureResolver;
import com.mini.framework.util.log.trace.SimpleMethodFeatureResolver;
import java.lang.reflect.Method;

public class MethodTracePointer {
    private MethodFeatureCache methodFeatureCache;
    private MethodFeatureResolver methodFeatureResolver = new SimpleMethodFeatureResolver();

    public void setMethodFeatureResolver(MethodFeatureResolver methodFeatureResolver) {
        this.methodFeatureResolver = methodFeatureResolver;
    }

    public MethodTracePointer(MethodFeatureCache methodFeatureCache) {
        this.methodFeatureCache = methodFeatureCache;
    }

    public void autoPoint() {
        this.autoPoint(3);
    }

    public void autoPoint(int preIndex) {
        StackTraceElement proMethod = Thread.currentThread().getStackTrace()[preIndex];
        String classPath = proMethod.getClassName();
        String name = proMethod.getMethodName();
        int line = proMethod.getLineNumber();
        String feature = String.format("%s.%s() line:%s", classPath, name, line);
        String traceId = this.methodFeatureCache.loadFeature(feature);
        LinkTraceFace.linkBeginPoint(traceId);
    }

    public void autoPoint(Method method) {
        String feature = this.methodFeatureResolver.resolveFeature(method);
        String traceId = this.methodFeatureCache.loadFeature(feature);
        LinkTraceFace.linkBeginPoint(traceId);
    }

    public void endTrace() {
        LinkTraceFace.clearTrace();
    }
}

