/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.oss;

import com.mini.framework.core.exception.BadDataException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.oss.OssWatermarkReplace;
import com.mini.framework.util.string.StringUtil;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Base64Utils;

public class OssWatermarkUtil {
    private static Logger logger = LogManager.getLogger();

    public static String resetWatermark(String url, List<OssWatermarkReplace> replaces) {
        String sureUrl = "/" + StringUtils.substringAfter((String)url, (String)"/");
        Collections.sort(replaces);
        Collections.reverse(replaces);
        for (OssWatermarkReplace replace : replaces) {
            int beginIndex = replace.getBase64Offset();
            int endIndex = beginIndex + replace.getBase64Length();
            String watermark = replace.getWatermarkContent();
            String oldBase64 = sureUrl.substring(beginIndex, endIndex);
            String suffix = OssWatermarkUtil.getOssProcessSuffix(OssWatermarkUtil.urlSafeDeBase64(oldBase64));
            AssertUtil.assertSupport(OssWatermarkUtil.getOssProcessSuffix(watermark).length() == 0, "\u6c34\u5370\u7d20\u6750[%s]\u4e0d\u652f\u6301\u6709process\u540e\u7f00", watermark);
            AssertUtil.assertSupport(!watermark.contains("http"), "\u6c34\u5370\u5185\u5bb9:[%s]\u4e0d\u80fd\u662f\u5b8c\u6574\u7684\u5730\u5740", watermark);
            String newBase64 = OssWatermarkUtil.urlSafeBase64(watermark + suffix);
            url = url.replace(oldBase64, newBase64);
        }
        return url;
    }

    private static String getOssProcessSuffix(String url) {
        String ossProcessSuffix = "?x-oss-process";
        if (url.contains(ossProcessSuffix)) {
            return url.substring(url.lastIndexOf(ossProcessSuffix));
        }
        return "";
    }

    public static String urlSafeDeBase64(String base64) {
        try {
            return new String(Base64Utils.decodeFromUrlSafeString((String)base64));
        }
        catch (IllegalArgumentException e) {
            throw new BadDataException((Throwable)e, "\u89e3\u5bc6base64\u65f6\u53d1\u73b0\u9519:%s", new Object[]{e.getMessage()});
        }
    }

    public static String urlSafeBase64(String content) {
        return Base64Utils.encodeToUrlSafeString((byte[])StringUtil.getUtf8Byte(content)).replaceAll("=", "");
    }
}

