/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.oss.bean.work;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.bean.desc.Descable;
import com.mini.framework.util.oss.bean.OssImageProcessParams;
import com.mini.framework.util.oss.bean.work.OssImageWork;
import com.mini.framework.util.oss.bean.work.OssImageWorkDeserializer;
import com.mini.framework.util.oss.bean.work.OssImageWorkSerializer;
import com.mini.framework.util.oss.bean.work.mark.HaveMarkPhotoFrame;
import com.mini.framework.util.oss.bean.work.mark.ImageMarkOssImageWork;
import com.mini.framework.util.oss.bean.work.mark.TextMarkOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.CircleByRadiusOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.CircleByRoundedCornersOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.LimitResizeModifyOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.OffsetCropModifyOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.RoundedCornersModifyOssImageWork;
import com.mini.framework.util.photo.PhotoBodilyFormType;
import com.mini.framework.util.string.GsonUtil;
import com.mini.framework.util.string.RegexUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class OssWorkProcess
implements Descable,
HaveMarkPhotoFrame {
    @Desc(value="\u9700\u8981\u5904\u7406\u7684\u5de5\u4f5c\u6d41\u7a0b")
    private @Desc(value="\u9700\u8981\u5904\u7406\u7684\u5de5\u4f5c\u6d41\u7a0b") List<OssImageWork> works;

    private static UnaryOperator<GsonBuilder> gsonBuilderUnaryOperator() {
        return builder -> builder.registerTypeAdapter(OssImageWork.class, (Object)new OssImageWorkDeserializer()).registerTypeAdapter(OssImageWork.class, (Object)new OssImageWorkSerializer());
    }

    private static Gson currFitGson() {
        return GsonUtil.createBaseBuilder(OssWorkProcess.gsonBuilderUnaryOperator()).create();
    }

    public List<OssImageWork> getWorks() {
        return this.works;
    }

    public void setWorks(List<OssImageWork> works) {
        this.works = works;
    }

    public static OssWorkProcess create(OssImageWork ... works) {
        return new OssWorkProcess(works);
    }

    public OssWorkProcess(OssImageWork ... works) {
        this.addWorks(works);
    }

    public List<OssImageWork> sureHaveWorks() {
        if (this.works == null) {
            this.works = new ArrayList<OssImageWork>();
        }
        return this.works;
    }

    public <W extends OssImageWork> OssWorkProcess addWorks(W ... works) {
        CollectionUtils.addAll(this.sureHaveWorks(), (Object[])works);
        return this;
    }

    public String toJson() {
        return OssWorkProcess.currFitGson().toJson((Object)this);
    }

    public static OssWorkProcess fromJson(String json) {
        AssertUtil.assertMethodRequire(json, "json");
        return (OssWorkProcess)OssWorkProcess.currFitGson().fromJson(json, OssWorkProcess.class);
    }

    @Override
    public UnaryOperator<GsonBuilder> registerGsonBuilder() {
        return OssWorkProcess.gsonBuilderUnaryOperator();
    }

    public String toOssUrl(String url, BiFunction<String, String, String> sameBucketPathFunction) {
        String bucketHost = RegexUtil.getUrlHost(url);
        List<OssImageWork> works = this.sureHaveWorks();
        Function<String, String> fn = image -> (String)sameBucketPathFunction.apply((String)image, bucketHost);
        List<OssImageProcessParams> opps = works.stream().sorted(Comparator.comparing(OssImageWork::showSorter)).map(work -> work.mapperProcessParams(fn)).collect(Collectors.toList());
        return OssImageProcessParams.applyMultiParams(url, opps);
    }

    @Deprecated
    public static OssWorkProcess createExmaple() {
        return OssWorkProcess.createExample();
    }

    public static OssWorkProcess createExample() {
        OssWorkProcess process = OssWorkProcess.create(new OssImageWork[0]).addWorks(ImageMarkOssImageWork.createExamples().toArray(new ImageMarkOssImageWork[0])).addWorks(TextMarkOssImageWork.createExamples().toArray(new TextMarkOssImageWork[0])).addWorks(OffsetCropModifyOssImageWork.createExamples().toArray(new OffsetCropModifyOssImageWork[0])).addWorks(LimitResizeModifyOssImageWork.createExamples().toArray(new LimitResizeModifyOssImageWork[0])).addWorks(RoundedCornersModifyOssImageWork.createExamples().toArray(new RoundedCornersModifyOssImageWork[0])).addWorks(CircleByRadiusOssImageWork.createExamples().toArray(new CircleByRadiusOssImageWork[0])).addWorks(CircleByRoundedCornersOssImageWork.createExamples().toArray(new CircleByRoundedCornersOssImageWork[0]));
        return process;
    }

    @Override
    public List<PhotoBodilyFormType> showFrameSchemes() {
        return this.sureHaveWorks().stream().map(HaveMarkPhotoFrame::mapperClassTypeMatch).filter(Optional::isPresent).map(Optional::get).map(HaveMarkPhotoFrame::showNonNullFrameSchemes).reduce(new ArrayList(), (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        });
    }
}

