/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.page;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.params.MapParams;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class QuerySorter {
    public static final String emptyAlert = "\u9700\u8981\u6392\u5e8f\u53c2\u6570sorterAsKey\u548csorterAsDesc";
    private String[] sorterAsKey;
    private Boolean[] sorterAsDesc;

    public Optional<Map<String, Boolean>> validate() {
        if (this.sorterAsDesc == null) {
            AssertUtil.assertNoBadReq(this.sorterAsKey == null, Status.BadReq.illParam, "sorterAsDesc[null]\u4e0esorterAsKey:%s\u4e0d\u80fd\u4e00\u4e2a\u4e3a\u7a7a\u4e00\u4e2a\u4e0d\u662f\u7a7a", Arrays.toString(this.sorterAsKey));
            return Optional.empty();
        }
        AssertUtil.assertNoBadReq(this.sorterAsKey != null, Status.BadReq.illParam, "sorterAsDesc%s\u4e0esorterAsKey:[null]\u4e0d\u80fd\u4e00\u4e2a\u4e3a\u7a7a\u4e00\u4e2a\u4e0d\u662f\u7a7a", Arrays.toString((Object[])this.sorterAsDesc));
        AssertUtil.assertNoBadReq(this.sorterAsKey.length == this.sorterAsDesc.length, Status.BadReq.illParam, "sorterAsDesc%s\u4e0esorterAsKey:[%s]\u957f\u5ea6\u5fc5\u987b\u4e00\u81f4", Arrays.toString((Object[])this.sorterAsDesc), Arrays.toString(this.sorterAsKey));
        LinkedHashMap<String, Boolean> sorter = new LinkedHashMap<String, Boolean>();
        for (int i = 0; i < this.sorterAsDesc.length; ++i) {
            String key = this.sorterAsKey[i];
            Boolean desc = this.sorterAsDesc[i];
            AssertUtil.assertNoBadReq(key != null && key.length() > 0, Status.BadReq.illParam, "sorterAsKey:[%s]\u7b2c[%s]\u4e2a\u4e0d\u80fd\u4e3a\u7a7a:[%s]", this.sorterAsKey, i + 1, key);
            AssertUtil.assertNoBadReq(desc != null, Status.BadReq.illParam, "sorterAsDesc:[%s]\u7b2c[%s]\u4e2a\u4e0d\u80fd\u4e3a\u7a7a:[%s]", this.sorterAsKey, i + 1, desc);
            AssertUtil.assertNoBadReq(!sorter.containsKey(key), Status.BadReq.illParam, "sorterAsDesc:[%s]\u7b2c[%s]\u4e2akey:[%s]\u51fa\u73b0\u91cd\u590d", this.sorterAsKey, i + 1, desc);
            sorter.put(key, desc);
        }
        return Optional.of(sorter);
    }

    public Consumer<MapParams> fillSorterProcess() {
        return this.fillSorterProcess(Function.identity());
    }

    public Consumer<MapParams> fillSorterProcess(Function<String, String> fieldGet) {
        Optional<Map<String, Boolean>> sorterOptional = this.validate();
        return mapParams -> {
            if (sorterOptional.isPresent()) {
                for (Map.Entry entry : ((Map)sorterOptional.get()).entrySet()) {
                    String realKey = (String)fieldGet.apply((String)entry.getKey());
                    AssertUtil.assertNotFatal(realKey != null, Status.Busy.bug, "fieldGet.apply(%s)\u4e3a\u7a7a", entry.getKey());
                    mapParams.orderBy(realKey, (Boolean)entry.getValue());
                }
            }
        };
    }

    public String[] getSorterAsKey() {
        return this.sorterAsKey;
    }

    public void setSorterAsKey(String[] sorterAsKey) {
        this.sorterAsKey = sorterAsKey;
    }

    public Boolean[] getSorterAsDesc() {
        return this.sorterAsDesc;
    }

    public void setSorterAsDesc(Boolean[] sorterAsDesc) {
        this.sorterAsDesc = sorterAsDesc;
    }
}

