/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.page;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.page.Section;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SectionUtil {
    public static void threadSection(Section sectionInfo, boolean force) {
        if (SectionUtil.completeSection(sectionInfo)) {
            PageHelper.offsetPage((int)sectionInfo.getOffset(), (int)sectionInfo.getLimit(), (boolean)sectionInfo.requireCount());
        } else {
            AssertUtil.assertNoBadReq(!force, Status.BadReq.noReq, "\u5fc5\u987b\u6709\u6b63\u786e\u7684\u5206\u9875\u53c2\u6570offset\u548climit, bean section:%s", sectionInfo);
        }
    }

    public static void valiSection(Section sectionInfo) {
        AssertUtil.assertNoBadReq(SectionUtil.completeSection(sectionInfo), Status.BadReq.noReq, "\u5fc5\u987b\u6709\u6b63\u786e\u7684\u5206\u9875\u53c2\u6570offset\u548climit, bean section:%s", sectionInfo);
    }

    public static boolean completeSection(Section sectionInfo) {
        return sectionInfo != null && sectionInfo.requireParamsComplete();
    }

    public static void threadSection(Section sectionInfo) {
        SectionUtil.threadSection(sectionInfo, true);
    }

    public static void threadSectionLimit(int limit) {
        SectionUtil.threadSection(new Section(0, limit, Integer.MAX_VALUE));
    }

    public static <T> Map<String, Object> quickMapList(List<T> list) {
        LinkedHashMap<String, Object> resp = new LinkedHashMap<String, Object>();
        if (list instanceof Page) {
            Page page = (Page)list;
            long count = page.getTotal();
            if (count < 0L) {
                resp.put("ignoreCount", true);
            } else {
                resp.put("count", count);
            }
        } else {
            resp.put("noPage", true);
        }
        resp.put("list", list);
        return resp;
    }

    public static <T> Map<String, Object> memorySectionMap(List<T> list, Section section) {
        Map<String, Object> map = SectionUtil.quickMapList(SectionUtil.memorySectionPage(list, section));
        map.put("count", map.get("total"));
        return map;
    }

    public static <I, T> void fillElementsToPage(List<I> list, List<T> page) {
    }

    public static <T> List<T> createEmptyPage() {
        Page page = new Page();
        page.setTotal(0L);
        return page;
    }

    public static <T> Page<T> memorySectionPage(List<T> list, Section section) {
        AssertUtil.assertMethodRequire(section, "section");
        AssertUtil.assertMethodRequire(list, "list");
        SectionUtil.valiSection(section);
        Page page = new Page();
        page.setTotal((long)list.size());
        page.setStartRow(section.getOffset().intValue());
        SectionUtil.retainSection(list, section);
        page.addAll(list);
        return page;
    }

    public static <T> List<T> retainLimit(List<T> list, int limit) {
        return SectionUtil.retainSection(list, new Section(0, limit));
    }

    public static <T> List<T> retainSection(List<T> list, Section section) {
        list.subList(0, Math.min(section.getOffset(), list.size())).clear();
        if (list.size() > section.getLimit()) {
            list.subList(section.getLimit(), list.size()).clear();
        }
        return list;
    }

    public static <T> Optional<Page<?>> findPageFromList(List<T> list) {
        if (list instanceof Page) {
            return Optional.of((Page)list);
        }
        return Optional.empty();
    }
}

