/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.relation;

import com.mini.framework.util.relation.Cascadable;
import com.mini.framework.util.relation.Cascader;
import com.mini.framework.util.relation.Flagable;
import com.mini.framework.util.relation.Relateder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class CollUtil {
    public static <T> void removeDeputy(Collection<T> coll, Relateder<? super T> relateder) {
        CollUtil.removeOnRelation(coll, relateder, -1);
    }

    public static <T> void removeOnRelation(Collection<T> coll, Relateder<? super T> relateder, int relation) {
        boolean change = true;
        while (change && coll.size() > 0) {
            change = true;
            Iterator<T> it1 = coll.iterator();
            Object toRemove = null;
            boolean conFlag = true;
            block1: while (it1.hasNext() && conFlag) {
                T element1 = it1.next();
                Iterator<T> it2 = coll.iterator();
                while (it2.hasNext() && conFlag) {
                    T element2 = it2.next();
                    if (relateder.showRelation(element1, element2) != relation) continue;
                    toRemove = element1;
                    conFlag = false;
                    continue block1;
                }
            }
            change = toRemove != null;
            if (!change) continue;
            coll.remove(toRemove);
        }
    }

    public static void distinctString(Collection<String> coll) {
        Flagable<String> flagable = new Flagable<String>(){

            @Override
            public String showFlag(String t) {
                return t;
            }
        };
        CollUtil.removeAlike(coll, flagable, 1);
    }

    public static <T> void removeAlike(Collection<T> coll, Flagable<? super T> flagable, int timeLimit) {
        HashMap<String, Integer> timeMap = new HashMap<String, Integer>();
        Iterator<T> it = coll.iterator();
        while (it.hasNext()) {
            T t = it.next();
            String flag = flagable.showFlag(t);
            Integer haveTime = (Integer)timeMap.get(flag);
            if (haveTime == null) {
                timeMap.put(flag, 1);
                continue;
            }
            if (haveTime < timeLimit) {
                timeMap.put(flag, haveTime + 1);
                continue;
            }
            it.remove();
        }
    }

    public static <N extends Cascadable<N>, C extends Collection<N>> C tranCascadeTree(C cascadables) {
        HashMap<String, Cascadable> nodeKeyMaps = new HashMap<String, Cascadable>();
        for (Cascadable cascadable : cascadables) {
            nodeKeyMaps.put(cascadable.showNodeKey(), cascadable);
        }
        Iterator<N> cit = cascadables.iterator();
        while (cit.hasNext()) {
            Cascadable ca = (Cascadable)cit.next();
            String superNodeKey = ca.showSuperNodeKey();
            Cascadable superNode = (Cascadable)nodeKeyMaps.get(superNodeKey);
            if (superNode == null) continue;
            cit.remove();
            superNode.addSonNode(ca);
        }
        return cascadables;
    }

    public static <N, C extends Collection<N>> C tranCascadeTree(C targetColl, Cascader<N> cascader) {
        HashMap<String, N> nodeKeyMaps = new HashMap<String, N>();
        for (N cascadable : targetColl) {
            nodeKeyMaps.put(cascader.showNodeKey(cascadable), cascadable);
        }
        Iterator<N> cit = targetColl.iterator();
        while (cit.hasNext()) {
            N ca = cit.next();
            String superNodeKey = cascader.showSuperNodeKey(ca);
            Object superNode = nodeKeyMaps.get(superNodeKey);
            if (superNode == null) continue;
            cit.remove();
            cascader.addSubNodes(superNode, ca);
        }
        return targetColl;
    }
}

