/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.relation;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.relation.Cascadable;
import com.mini.framework.util.relation.Cascader;
import com.mini.framework.util.relation.Flagable;
import com.mini.framework.util.relation.Indexable;
import com.mini.framework.util.relation.Relateder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ShipUtil {
    public static <T> void removeDeputy(Collection<T> coll, Relateder<? super T> relateder) {
        ShipUtil.removeOnRelation(coll, relateder, -1);
    }

    public static <T, K> void distinct(Collection<T> coll, final Function<T, K> keyGetter) {
        ShipUtil.removeAlike(coll, new Flagable<T>(){

            @Override
            public String showFlag(T t) {
                return String.valueOf(keyGetter.apply(t));
            }
        }, 1);
    }

    public static <T> void removeOnRelation(Collection<T> coll, Relateder<? super T> relateder, int relation) {
        boolean change = true;
        while (change && coll.size() > 0) {
            change = true;
            Iterator<T> it1 = coll.iterator();
            Object toRemove = null;
            boolean conFlag = true;
            block1: while (it1.hasNext() && conFlag) {
                T element1 = it1.next();
                Iterator<T> it2 = coll.iterator();
                while (it2.hasNext() && conFlag) {
                    T element2 = it2.next();
                    if (relateder.showRelation(element1, element2) != relation) continue;
                    toRemove = element1;
                    conFlag = false;
                    continue block1;
                }
            }
            change = toRemove != null;
            if (!change) continue;
            coll.remove(toRemove);
        }
    }

    public static void distinctString(Collection<String> coll) {
        Flagable<String> flagable = new Flagable<String>(){

            @Override
            public String showFlag(String t) {
                return t;
            }
        };
        ShipUtil.removeAlike(coll, flagable, 1);
    }

    public static <T> void removeAlike(Collection<T> coll, Flagable<? super T> flagable, int timeLimit) {
        HashMap<String, Integer> timeMap = new HashMap<String, Integer>();
        Iterator<T> it = coll.iterator();
        while (it.hasNext()) {
            T t = it.next();
            String flag = flagable.showFlag(t);
            Integer haveTime = (Integer)timeMap.get(flag);
            if (haveTime == null) {
                timeMap.put(flag, 1);
                continue;
            }
            if (haveTime < timeLimit) {
                timeMap.put(flag, haveTime + 1);
                continue;
            }
            it.remove();
        }
    }

    public static <T> void tranCascadeTree(Collection<? extends Cascadable<T>> cascadables) {
        ArrayList<Cascadable<T>> superTemps = new ArrayList<Cascadable<T>>(cascadables);
        for (Cascadable cascadable : superTemps) {
            Iterator<Cascadable<T>> it = cascadables.iterator();
            while (it.hasNext()) {
                Cascadable<T> cascadable2 = it.next();
                if (cascadable2.showSuperNodeKey() == null || !cascadable2.showSuperNodeKey().equals(cascadable.showNodeKey())) continue;
                it.remove();
                cascadable.addSonNode(cascadable2);
            }
        }
    }

    public static <T> List<T> tranTreeToList(Cascadable<T> cascadable) {
        List<T> result = cascadable.showSonNodes();
        result.add(cascadable);
        return result;
    }

    public static <T> void tranTreeToList(List<? extends Cascadable<T>> cascadables) {
        for (int i = 0; i < cascadables.size(); ++i) {
            Cascadable<T> cascadable = cascadables.get(i);
            Iterator<T> sonNodeIt = cascadable.showSonNodes().iterator();
            while (sonNodeIt.hasNext()) {
                T sonNode = sonNodeIt.next();
                cascadables.add((Cascadable<T>)sonNode);
                sonNodeIt.remove();
            }
        }
    }

    public static <T> void tranCascadeTree(Collection<T> targColl, Cascader<T> cascader) {
        ArrayList<T> superTemps = new ArrayList<T>(targColl);
        for (Object superTemp : superTemps) {
            Iterator<T> it = targColl.iterator();
            while (it.hasNext()) {
                T cascadable = it.next();
                if (cascader.showSuperNodeKey(cascadable) == null || !cascader.showSuperNodeKey(cascadable).equals(cascader.showNodeKey(superTemp))) continue;
                it.remove();
                cascader.addSubNodes(superTemp, cascadable);
            }
        }
    }

    public static <T> T findByNodeKey(Collection<? extends Cascadable<T>> cascadables, String nodeKey) {
        Cascadable<T> cascadable;
        AssertUtil.assertAllNotNull(Status.BadReq.def, "\u7ea7\u8054[%s]\u548cnodeKey[%s]\u90fd\u4e0d\u80fd\u4e3a\u7a7a", cascadables, nodeKey);
        T found = null;
        Iterator<Cascadable<T>> it = cascadables.iterator();
        while (it.hasNext() && (found = (T)ShipUtil.findByNodeKey(cascadable = it.next(), nodeKey)) == null) {
        }
        return found;
    }

    public static <T> T findByNodeKey(Cascadable<T> cascadable, String nodeKey) {
        AssertUtil.assertAllNotNull(Status.BadReq.def, "\u7ea7\u8054[%s]\u548cnodeKey[%s]\u90fd\u4e0d\u80fd\u4e3a\u7a7a", cascadable, nodeKey);
        if (nodeKey.equals(cascadable.showNodeKey())) {
            return (T)cascadable;
        }
        return ShipUtil.findByNodeKey(cascadable.showSonNodes(), nodeKey);
    }

    public static <T, I extends Comparable<I>, F> void indexSort(List<T> list, Function<T, F> field, Map<F, I> mapper) {
        ShipUtil.indexSort(list, t -> (Comparable)mapper.get(field.apply(t)));
    }

    public static <T, I extends Comparable<I>> void indexSort(List<T> list, final Function<T, I> index) {
        Comparator comp = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)index.apply(o1)).compareTo(index.apply(o2));
            }
        };
        list.sort(comp);
    }

    public static <T extends Indexable<I>, I extends Comparable<I>> void indexSort(List<T> list) {
        ShipUtil.indexSort(list, t -> t.index());
    }
}

