/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateRange;
import com.mini.framework.util.report.statistics.ForkQueryable;
import com.mini.framework.util.report.statistics.protocol.TimeRegionRange;
import com.mini.framework.util.report.statistics.protocol.TimeRegionUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

public interface Statistics
extends ForkQueryable {
    public String showStatisticsFeatureKey();

    public static void hotWholeNativeRegion(Date dataStatisticsOffsetDate, Date limitDate, BiConsumer<TimeRegionUnit, DateRange> queryExecutor, Function<RuntimeException, Optional<RuntimeException>> exceptionHandle) {
        int maxRegion = 1000;
        Stream.of(TimeRegionUnit.hour, TimeRegionUnit.day, TimeRegionUnit.week, TimeRegionUnit.month, TimeRegionUnit.season, TimeRegionUnit.year).forEach(timeUnit -> {
            Date dateRangeOffset = timeUnit.nearLazyFenceRangeDate(dataStatisticsOffsetDate);
            Date dateRangeLimit = timeUnit.nearLazyFenceRangeDate(limitDate);
            List<TimeRegionRange> nativeRegionFences = timeUnit.regionFences(dateRangeOffset, dateRangeLimit);
            ArrayList<List<TimeRegionRange>> querySteps = new ArrayList<List<TimeRegionRange>>();
            while (nativeRegionFences.size() > maxRegion) {
                List<TimeRegionRange> oneStepRegions = nativeRegionFences.subList(0, maxRegion);
                querySteps.add(new ArrayList<TimeRegionRange>(oneStepRegions));
                oneStepRegions.clear();
            }
            querySteps.add(nativeRegionFences);
            querySteps.stream().filter(regions -> !regions.isEmpty()).map(regions -> {
                LinkedList linked = new LinkedList(regions);
                return DateRange.create(((TimeRegionRange)linked.getFirst()).getOffset(), ((TimeRegionRange)linked.getLast()).getOffset());
            }).forEach(dateRange -> {
                try {
                    queryExecutor.accept((TimeRegionUnit)timeUnit, (DateRange)dateRange);
                }
                catch (RuntimeException e) {
                    Optional exceptionOptional = (Optional)exceptionHandle.apply(e);
                    AssertUtil.assertNotFatalBug(exceptionOptional != null, "\u4e0d\u7ba1\u4ec0\u4e48\u60c5\u51b5 exceptionHandle \u4e0d\u80fd\u8fd4\u56de null", new Object[0]);
                    exceptionOptional.ifPresent(exception -> {
                        throw exception;
                    });
                }
            });
        });
    }
}

