/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.protocol.process;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.report.statistics.protocol.process.ForkQuerySpot;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ForkQueryProcess {
    private List<ForkQuerySpot<?>> querySpots = new ArrayList();
    private ExecutorService fixedThreadPool;
    private Boolean otherThread;

    public static ForkQueryProcess create(Optional<Integer> poolSizeOptional, ThreadFactory threadFactory) {
        ForkQueryProcess instance = new ForkQueryProcess();
        poolSizeOptional.ifPresent(poolSize -> {
            instance.fixedThreadPool = new ThreadPoolExecutor(1, (int)poolSize, 180000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
            instance.otherThread = true;
        });
        if (!poolSizeOptional.isPresent()) {
            instance.otherThread = false;
        }
        return instance;
    }

    public <R> R pushQueryNowExecute(Supplier<R> queryFunction, Object processParams) {
        return this.pushQuery(queryFunction, processParams).get();
    }

    public <R> Supplier<R> pushQuery(Supplier<R> queryFunction, Object processParams) {
        if (this.otherThread.booleanValue()) {
            AssertUtil.assertNotFatal(!this.fixedThreadPool.isShutdown(), "\u7ebf\u7a0b\u6c60\u5df2\u7ed3\u675f\u4e0d\u80fd\u5728\u6dfb\u52a0\u4efb\u52a1", new Object[0]);
            ForkQuerySpot spot = ForkQuerySpot.createThenAsyncBegin(queryFunction, this.fixedThreadPool, processParams);
            this.querySpots.add(spot);
            return () -> {
                try {
                    return spot.showAsyncExecutor().get();
                }
                catch (InterruptedException e) {
                    throw new ServerException((Throwable)e, "\u7ebf\u7a0b\u88ab\u5f02\u5e38\u6253\u65ad", new Object[0]);
                }
                catch (ExecutionException e) {
                    throw new ServerException((Throwable)e, "\u6267\u884c\u4e00\u4e2a\u67e5\u8be2\u7684\u65f6\u5019\u9519\u8bef\u4e86", new Object[0]);
                }
            };
        }
        ForkQuerySpot spot = new ForkQuerySpot();
        this.querySpots.add(spot);
        return () -> spot.fillThenSyncBegin(queryFunction);
    }

    public ForkQueryProcess mergeOtherQuerySpots(ForkQueryProcess other) {
        this.querySpots.addAll(other.querySpots);
        return this;
    }

    public void closeResource() {
        if (this.fixedThreadPool != null) {
            this.fixedThreadPool.shutdown();
        }
        this.fixedThreadPool = null;
    }

    public List<ForkQuerySpot<?>> getQuerySpots() {
        return this.querySpots;
    }

    public void setQuerySpots(List<ForkQuerySpot<?>> querySpots) {
        this.querySpots = querySpots;
    }

    public Boolean getOtherThread() {
        return this.otherThread;
    }

    public void setOtherThread(Boolean otherThread) {
        this.otherThread = otherThread;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

