/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.ranking;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateRange;
import com.mini.framework.util.report.statistics.exception.DuplicateUniqueKeyPersistentException;
import com.mini.framework.util.report.statistics.protocol.RankingDimension;
import com.mini.framework.util.report.statistics.protocol.StatisticsSerializeParams;
import com.mini.framework.util.report.statistics.protocol.TimeRegionRange;
import com.mini.framework.util.report.statistics.protocol.TimeRegionUnit;
import com.mini.framework.util.report.statistics.protocol.params.QueryParamsOverview;
import com.mini.framework.util.report.statistics.protocol.process.ProcessContext;
import com.mini.framework.util.report.statistics.ranking.RankingStatistics;
import com.mini.framework.util.report.statistics.ranking.bean.NativeDateScoreRankingScheme;
import com.mini.framework.util.report.statistics.ranking.bean.RankingElementSummationAmount;
import com.mini.framework.util.report.statistics.ranking.bean.StatisticsRankingTable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface RankingDimensionFeature<P extends StatisticsSerializeParams, E extends RankingElementSummationAmount<E>>
extends RankingStatistics<P, E> {
    public static final Logger logger;

    @Override
    default public String showStatisticsFeatureKey() {
        return this.showStatisticsDimension().showDimensionStringKey();
    }

    public void saveRankingTableToCache(String var1, StatisticsRankingTable<E> var2);

    public StatisticsRankingTable<E> accumulateRankingTableToCache(String var1, StatisticsRankingTable<E> var2, boolean var3);

    public Optional<NativeDateScoreRankingScheme> queryNatureTimeRankingScheme(String var1, TimeRegionUnit var2, Date var3);

    public Optional<NativeDateScoreRankingScheme> queryNatureTimeRankingScheme(String var1, String var2);

    public List<NativeDateScoreRankingScheme> queryBatchNatureTimeRankingScheme(String var1, Set<String> var2);

    public NativeDateScoreRankingScheme initThenSaveNatureRankingScheme(P var1, TimeRegionUnit var2, Date var3);

    public StatisticsRankingTable<E> statisticsDateRangeRankingFromImpl(DateRange var1, P var2, int var3);

    public Optional<StatisticsRankingTable<E>> queryCacheRankingTable(String var1, Optional<Integer> var2);

    public Map<String, StatisticsRankingTable<E>> queryBatchCacheRankingTable(Map<String, Optional<Integer>> var1);

    public int maxCacheRankingElementSize(TimeRegionUnit var1);

    default public Map<String, StatisticsRankingTable<E>> queryBatchCacheRankingTable(Set<String> keys, Optional<Integer> headOptional) {
        Map<String, Optional<Integer>> keyHeadOptionalMapper = keys.stream().collect(Collectors.toMap(Function.identity(), key -> headOptional));
        return this.queryBatchCacheRankingTable(keyHeadOptionalMapper);
    }

    public void updateSchemeTouchPoint(String var1, TimeRegionUnit var2, Date var3, Date var4, Optional<Boolean> var5);

    public E createEmptyElement(String var1);

    public RankingDimension showStatisticsDimension();

    public TimeRegionUnit acceptStatisticsOriginMaxUnit();

    public TimeRegionUnit acceptCacheStatisticsMinDateUnit();

    public long maxCacheStatisticsIncrementMilliseconds();

    default public E utilFullyEmptyElement() {
        return this.createEmptyElement("");
    }

    public Optional<TimeRegionUnit> acceptSkipStatisticsDefectDateUnit();

    default public Date countUsefulHistoryLimitDate(Date historyLimitDate) {
        return this.acceptSkipStatisticsDefectDateUnit().map(unit -> unit.nearLazyFenceRangeDate(historyLimitDate)).orElse(historyLimitDate);
    }

    default public boolean ifSkipCacheStatisticsIncrement(long milliseconds) {
        return milliseconds < this.maxCacheStatisticsIncrementMilliseconds();
    }

    default public void previewValidate() {
        Function<String, ServerException> supplier = message -> new ServerException(Status.Server.programConfigJava, "\u7a0b\u5e8f\u4f7f\u7528\u6709\u95ee\u9898\u9700\u8981\u68c0\u67e5utilFullyEmptyElement()\u51fa\u9519,%s", new Object[]{message});
        this.utilFullyEmptyElement().validateOriginComplete(supplier);
        TimeRegionUnit maxUnit = this.acceptStatisticsOriginMaxUnit();
        List supportMaxUnits = Stream.of(TimeRegionUnit.year, TimeRegionUnit.season, TimeRegionUnit.month, TimeRegionUnit.week, TimeRegionUnit.day).collect(Collectors.toList());
        if (!supportMaxUnits.contains(maxUnit)) {
            throw supplier.apply(String.format("\u6700\u5927\u652f\u6301\u7684\u7edf\u8ba1\u70b9:[%s]\u5e94\u8be5\u5728\u6b64\u8303\u56f4\u5185:%s", maxUnit, supportMaxUnits));
        }
    }

    default public void updateSchemeTouchPoint(P params, TimeRegionRange regionRange, Date touchLimit, Optional<Boolean> touchUpperLimitOptional) {
        this.updateSchemeTouchPoint(params.uniqueSerializeMd5(), regionRange.getUnit(), regionRange.getOffset(), touchLimit, touchUpperLimitOptional);
    }

    default public NativeDateScoreRankingScheme queryOrInitNatureTimeRankingScheme(P params, TimeRegionRange regionRange) {
        return this.queryNatureTimeRankingScheme(params, regionRange).orElseGet(() -> this.initThenSaveNatureRankingScheme(params, regionRange));
    }

    default public Optional<NativeDateScoreRankingScheme> queryNatureTimeRankingScheme(P params, TimeRegionRange regionRange) {
        return this.queryNatureTimeRankingScheme(params.uniqueSerializeMd5(), regionRange.getUnit(), regionRange.getOffset());
    }

    default public List<NativeDateScoreRankingScheme> queryBatchNatureTimeRankingScheme(P params, List<TimeRegionRange> regionRanges) {
        return this.queryBatchNatureTimeRankingScheme(params.uniqueSerializeMd5(), regionRanges.stream().map(TimeRegionRange::unitOffsetUnionString).collect(Collectors.toSet()));
    }

    default public NativeDateScoreRankingScheme initThenSaveNatureRankingScheme(P params, TimeRegionRange regionRange) {
        NativeDateScoreRankingScheme scheme = null;
        try {
            scheme = this.initThenSaveNatureRankingScheme(params, regionRange.getUnit(), regionRange.getOffset());
            AssertUtil.assertNormal(scheme != null, () -> new ServerException("initThenSaveNatureRankingScheme \u65b9\u6cd5\u5fc5\u987b\u6709\u8fd4\u56de\u503c", new Object[0]));
            if (!1.$assertionsDisabled && scheme == null) {
                throw new AssertionError();
            }
        }
        catch (DuplicateUniqueKeyPersistentException e) {
            logger.debug("\u8bb0\u5f55\u4e00\u4e2a\u53ef\u4ee5\u5ffd\u7565\u7684\u5f02\u5e38", (Throwable)e);
            logger.warn(String.format("\u51fa\u73b0\u4e00\u4e2a\u552f\u4e00\u7ea6\u675f\u5f02\u5e38 field:[%s],key:[%s],%s  \u5f53\u524d\u5f02\u5e38\u53ef\u4ee5\u5ffd\u7565", e.getUniqueKeyField(), e.getUniqueKey(), e.getMessage()));
            scheme = this.queryNatureTimeRankingScheme(params, regionRange).orElseThrow(() -> new ServerException("\u53d1\u73b0\u8054\u5408\u552f\u4e00\u7ea6\u675fkey:[%s]\u51b2\u7a81\u53c8\u67e5\u4e0d\u5230\u6570\u636eparams:[%s],region:%s", new Object[]{e.getUniqueKey(), params.uniqueSerialize(), regionRange}));
        }
        this.saveRankingTableToCache(scheme.getRankingKey(), StatisticsRankingTable.createEmpty());
        return scheme;
    }

    default public StatisticsRankingTable<E> statisticsDateRangeRanking(ProcessContext context, P params, DateRange dateRange, Optional<Integer> headOptional, Date queryLimitDate) {
        this.previewValidate();
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        DateRange fullyStatisticsDateRange = dateRange.limitUpperDate(realStatisticsLimitDate);
        ArrayList regionChipDateRanges = new ArrayList();
        int retainSize = this.maxCacheRankingElementSize(this.acceptCacheStatisticsMinDateUnit());
        List<TimeRegionRange> requireQueryRegions = TimeRegionRange.splitRangeLessPointHandleChip(fullyStatisticsDateRange, this.acceptCacheStatisticsMinDateUnit(), this.acceptStatisticsOriginMaxUnit(), regionChipDateRanges::add);
        List fullyCacheRegionUnionKeys = this.queryBatchNatureTimeRankingScheme(params, requireQueryRegions).stream().filter(NativeDateScoreRankingScheme::ifTouchFullyScope).collect(Collectors.toList());
        StatisticsRankingTable fullyCacheRanking = this.queryBatchCacheRankingTable(fullyCacheRegionUnionKeys.stream().map(NativeDateScoreRankingScheme::getRankingKey).collect(Collectors.toSet()), Optional.empty()).values().stream().filter(Objects::nonNull).reduce(StatisticsRankingTable.reduceAccumulator(this::createEmptyElement)).orElse(StatisticsRankingTable.createEmpty());
        List futureRequireCountRegionRankings = requireQueryRegions.stream().filter(region -> !fullyCacheRegionUnionKeys.stream().map(NativeDateScoreRankingScheme::getRegionUnionKey).collect(Collectors.toSet()).contains(region.unitOffsetUnionString())).sorted(TimeRegionRange.randomSorter()).map(region -> context.getProcess().pushQuery(() -> this.statisticsNativeDateOneScopeRanking(context, params, (TimeRegionRange)region, Optional.empty(), realStatisticsLimitDate), QueryParamsOverview.create((Object)params, region))).collect(Collectors.toList());
        List futureRegionChipDateRangeRankings = regionChipDateRanges.stream().map(regionChip -> context.getProcess().pushQuery(() -> this.statisticsDateRangeRankingFromImpl((DateRange)regionChip, params, retainSize), QueryParamsOverview.create((Object)params, regionChip))).collect(Collectors.toList());
        StatisticsRankingTable requireCountRegionRanking = futureRequireCountRegionRankings.stream().map(Supplier::get).reduce(StatisticsRankingTable.reduceAccumulator(this::createEmptyElement)).orElse(StatisticsRankingTable.createEmpty());
        StatisticsRankingTable regionChipDateRangeRanking = futureRegionChipDateRangeRankings.stream().map(Supplier::get).reduce(StatisticsRankingTable.reduceAccumulator(this::createEmptyElement)).orElse(StatisticsRankingTable.createEmpty());
        StatisticsRankingTable fullyScopeRanking = Stream.of(fullyCacheRanking, requireCountRegionRanking, regionChipDateRangeRanking).reduce(StatisticsRankingTable.reduceAccumulator(this::createEmptyElement)).orElse(StatisticsRankingTable.createEmpty());
        fullyScopeRanking.markResultMeta(realStatisticsLimitDate);
        fullyScopeRanking.fillQueryProcess(context.getProcess());
        return fullyScopeRanking.retainLimitHead(headOptional);
    }

    @Override
    default public StatisticsRankingTable<E> statisticsNativeDateRanking(ProcessContext context, P params, TimeRegionRange regionRange, int topSize, Date queryLimitDate) {
        int limitHead = this.maxCacheRankingElementSize(regionRange.getUnit());
        if (topSize > limitHead) {
            throw new ServerException(Status.Server.programConfigJava, "\u4e0d\u5141\u8bb8\u4f7f\u7528topSize:[%s]\u4e0a\u9650\u4e3a:[%s]", new Object[]{topSize, limitHead});
        }
        return this.statisticsDateRangeRanking(context, params, regionRange.showDateRange(), Optional.of(topSize), queryLimitDate);
    }

    default public StatisticsRankingTable<E> statisticsNativeDateOneScopeRanking(ProcessContext context, P params, TimeRegionRange regionRange, Optional<Integer> headOptional, Date queryLimitDate) {
        this.previewValidate();
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        NativeDateScoreRankingScheme rankingScheme = this.queryOrInitNatureTimeRankingScheme(params, regionRange);
        Optional<DateRange> requireTouchRangeOptional = rankingScheme.countRequireTouchRange(realStatisticsLimitDate);
        StatisticsRankingTable ranking = requireTouchRangeOptional.map(requireTouchRange -> {
            StatisticsRankingTable<E> requireTouchRanking = this.statisticsDateRangeRankingFromImpl((DateRange)requireTouchRange, params, this.maxCacheRankingElementSize(regionRange.getUnit()));
            requireTouchRanking.stream().forEach(element -> element.validateComplete(message -> new ServerException(Status.Server.programConfigJava, "\u6570\u636e\u6709\u9519\u8bef%s,\u6570\u636e\u662f:%s", new Object[]{message, element})));
            requireTouchRanking.sorterDesc();
            boolean skipUpdateScheme = this.ifSkipCacheStatisticsIncrement(requireTouchRange.showTimeScopeMilliseconds());
            StatisticsRankingTable<E> fullyRanking = this.accumulateRankingTableToCache(rankingScheme.getRankingKey(), requireTouchRanking, !skipUpdateScheme);
            if (!skipUpdateScheme) {
                this.updateSchemeTouchPoint(params, regionRange, requireTouchRange.getMaxDate(), Optional.of(rankingScheme.ifTouchRangeUpperLimit(realStatisticsLimitDate)));
            }
            return fullyRanking;
        }).orElseGet(() -> this.queryCacheRankingTable(rankingScheme.getRankingKey(), headOptional).orElse(StatisticsRankingTable.createEmpty()));
        ranking.markResultMeta(realStatisticsLimitDate);
        ranking.fillQueryProcess(context.getProcess());
        return ranking;
    }

    @Override
    default public StatisticsRankingTable<E> statisticsNativeDateArrayRanking(ProcessContext context, P params, TimeRegionUnit regionUnit, DateRange scopeRange, int topSize, Date queryLimitDate) {
        this.previewValidate();
        Date realStatisticsLimitDate = this.countUsefulHistoryLimitDate(queryLimitDate);
        Date rangeMinDate = scopeRange.getMinDate();
        Date rangeMaxDate = scopeRange.getMaxDate();
        StatisticsRankingTable<E> result = this.statisticsDateRangeRanking(context, params, DateRange.create(rangeMinDate, rangeMaxDate), Optional.of(topSize), queryLimitDate);
        result.markResultMeta(realStatisticsLimitDate);
        result.fillQueryProcess(context.getProcess());
        return result;
    }

    @Override
    default public StatisticsRankingTable<E> statisticsCustomDateRangeRanking(ProcessContext context, P params, DateRange dateRange, int topSize, Date queryLimitDate) {
        this.previewValidate();
        StatisticsRankingTable<E> result = this.statisticsDateRangeRanking(context, params, dateRange, Optional.of(topSize), queryLimitDate);
        return result;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        logger = LogManager.getLogger(RankingDimensionFeature.class);
    }
}

