/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.summation.bean;

import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.exception.standard.CustomExceptionSupplier;
import com.mini.framework.util.report.statistics.protocol.DivideDenominatorNumeratorSummation;
import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class SummationElementAmount
implements OneStatisticsResult,
DivideDenominatorNumeratorSummation<SummationElementAmount> {
    private StatisticsResultMeta resultMeta;
    private ForkQueryProcess process;
    protected Long count;
    protected Long sum;
    protected Long max;
    protected Long min;
    protected Long expand;

    public SummationElementAmount() {
    }

    public boolean haveAmount() {
        return this.count != null && this.sum != null;
    }

    @Override
    public void mapperAmountDivideByOther(long expand, boolean numeratorSum, boolean denominatorSum, SummationElementAmount other) {
        this.mergeOtherResultMeta(other);
        Long numeratorValue = this.showValueSumOrCount(numeratorSum);
        Long denominatorValue = other.showValueSumOrCount(denominatorSum);
        this.min = null;
        this.max = null;
        this.expand = expand;
        this.count = denominatorValue == 0L ? null : Long.valueOf((long)(1.0 * (double)numeratorValue.longValue() / (double)denominatorValue.longValue() * (double)expand));
        this.sum = this.count;
    }

    @Override
    public void clearRedundancyFields() {
    }

    public Long showValueSumOrCount(boolean sumOrCount) {
        return sumOrCount ? this.sum : this.count;
    }

    public SummationElementAmount(Long count, Long sum, Long min, Long max, Long expand) {
        this.count = count;
        this.sum = sum;
        this.min = min;
        this.max = max;
        this.expand = expand;
    }

    public static SummationElementAmount createZeroEmpty() {
        return new SummationElementAmount(0L, 0L, null, null, null);
    }

    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(this.resultMeta);
    }

    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public SummationElementAmount refAsSummationElementAmount() {
        return this;
    }

    public static Comparator<SummationElementAmount> sorterBySum(boolean thenCount) {
        Comparator<SummationElementAmount> sumSorter = Comparator.comparing(SummationElementAmount::getSum);
        if (thenCount) {
            return sumSorter.thenComparing(SummationElementAmount::getCount);
        }
        return sumSorter;
    }

    public static Comparator<SummationElementAmount> sorterByCount(boolean thenSum) {
        Comparator<SummationElementAmount> countSorter = Comparator.comparing(SummationElementAmount::getCount);
        if (thenSum) {
            return countSorter.thenComparing(SummationElementAmount::getSum);
        }
        return countSorter;
    }

    public static <E extends CustomException> UnaryOperator<SummationElementAmount> validateRightFunction(CustomExceptionSupplier<E> exceptionSupplier) throws E {
        return amonut -> amonut.validateRight(exceptionSupplier);
    }

    public <E extends CustomException> SummationElementAmount validateRight(CustomExceptionSupplier<E> exceptionSupplier) throws E {
        this.validateComplete(exceptionSupplier);
        this.validateReasonable(exceptionSupplier);
        return this;
    }

    public <E extends CustomException> SummationElementAmount validateReasonable(CustomExceptionSupplier<E> exceptionSupplier) throws E {
        if (this.count == 0L) {
            if (this.max != null) {
                throw exceptionSupplier.supply("max:[%s]\u4e0d\u7b26\u5408\u903b\u8f91,\u56e0\u4e3a\u5f53\u524dcount:[%s]\uff0ccount\u4e3a0\u8bf4\u660e\u6ca1\u6709\u6570\u636e\u4e5f\u4e0d\u53ef\u80fd\u6709max,\u5b83\u5e94\u8be5\u4e3a\u7a7a", new Object[]{this.max, this.count});
            }
            if (this.min != null) {
                throw exceptionSupplier.supply("min:[%s]\u4e0d\u7b26\u5408\u903b\u8f91,\u56e0\u4e3a\u5f53\u524dcount:[%s]\uff0ccount\u4e3a0\u8bf4\u660e\u6ca1\u6709\u6570\u636e\u4e5f\u4e0d\u53ef\u80fd\u6709min,\u5b83\u5e94\u8be5\u4e3a\u7a7a", new Object[]{this.min, this.count});
            }
        }
        return this;
    }

    public <E extends CustomException> SummationElementAmount validateComplete(CustomExceptionSupplier<E> exceptionSupplier) throws E {
        if (this.count == null) {
            throw exceptionSupplier.supply("count \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.sum == null) {
            throw exceptionSupplier.supply("sum \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.max == null != (this.min == null)) {
            throw exceptionSupplier.supply("max:[%s] \u548c min:[%s] \u8981\u4e48\u90fd\u4e3a\u7a7a\u8981\u4e48\u90fd\u4e0d\u4e3a\u7a7a", new Object[]{this.max, this.min});
        }
        return this;
    }

    public static SummationElementAmount createEmptyInstance() {
        SummationElementAmount instance = new SummationElementAmount();
        instance.count = 0L;
        instance.sum = 0L;
        return instance;
    }

    public void mergeOtherAmount(SummationElementAmount other) {
        List amounts = Stream.of(this, other).collect(Collectors.toList());
        this.max = amounts.stream().map(SummationElementAmount::getMax).filter(Objects::nonNull).max(Long::compareTo).orElse(null);
        this.min = amounts.stream().map(SummationElementAmount::getMin).filter(Objects::nonNull).min(Long::compareTo).orElse(null);
        this.sum = amounts.stream().mapToLong(SummationElementAmount::getSum).sum();
        this.count = amounts.stream().mapToLong(SummationElementAmount::getCount).sum();
    }

    public static SummationElementAmount mergeAmount(SummationElementAmount amount1, SummationElementAmount amount2) {
        SummationElementAmount instance = SummationElementAmount.createEmptyInstance();
        instance.mergeOtherAmount(amount1);
        instance.mergeOtherAmount(amount2);
        return instance;
    }

    public StatisticsResultMeta getResultMeta() {
        return this.resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(this.process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }

    public ForkQueryProcess getProcess() {
        return this.process;
    }

    public void setProcess(ForkQueryProcess process) {
        this.process = process;
    }

    public Long getMax() {
        return this.max;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public Long getMin() {
        return this.min;
    }

    public void setMin(Long min) {
        this.min = min;
    }

    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public Long getSum() {
        return this.sum;
    }

    public Long getExpand() {
        return this.expand;
    }

    public void setExpand(Long expand) {
        this.expand = expand;
    }

    public void setSum(Long sum) {
        this.sum = sum;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void copyToOther(SummationElementAmount other) {
        other.min = this.min;
        other.max = this.max;
        other.count = this.count;
        other.sum = this.sum;
        other.process = this.process;
        other.resultMeta = this.resultMeta;
        other.expand = this.expand;
    }
}

