/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.sql.view.bean;

import com.github.pagehelper.Page;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.exception.standard.CustomExceptionSupplier;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.page.SectionUtil;
import com.mini.framework.util.sql.view.able.ObjectValueReader;
import com.mini.framework.util.sql.view.bean.ColumnDefine;
import com.mini.framework.util.sql.view.bean.SqlViewBean;
import com.mini.framework.util.sql.view.bean.TableValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TableDefine
extends SqlViewBean {
    private List<ColumnDefine> columns;

    public <T> TableValue resolve(List<Map<String, T>> mapList) {
        TableValue tableValue = TableValue.create(this.columns);
        Optional<Page<?>> page = SectionUtil.findPageFromList(mapList);
        mapList.stream().map(ObjectValueReader::create).forEach(tableValue::addRow);
        tableValue.fillFromPage(page);
        return tableValue;
    }

    public <E extends CustomException> TableDefine validateComplete(CustomExceptionSupplier<E> exceptionSupplier) {
        exceptionSupplier.applyAssert(this.columns != null, "\u5c5e\u6027columns\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        this.columns.forEach(column -> column.validateComplete(exceptionSupplier.becauseFrom(columnError -> String.format("table\u4e2d\u6709\u4e00\u5217\u9519\u8bef:%s", columnError))));
        return this;
    }

    public TableDefine addColumnDefine(ColumnDefine columnDefine) {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnDefine>();
        }
        this.columns.add(columnDefine);
        return this;
    }

    public static <E extends CustomException> TableDefine fromJson(String json, CustomExceptionSupplier<E> exceptionSupplier) {
        AssertUtil.assertMethodRequire(json, "json");
        try {
            return (TableDefine)TableDefine.fromJson(json, TableDefine.class);
        }
        catch (Exception e) {
            throw exceptionSupplier.supply("json\u65e0\u6cd5\u89e3\u6790\u6210TableDefine,\u51fa\u73b0\u9519\u8bef%s", new Object[]{e.getMessage()});
        }
    }

    public static TableDefine fromJson(String json) {
        return (TableDefine)TableDefine.fromJson(json, TableDefine.class);
    }

    public List<ColumnDefine> getColumns() {
        return this.columns;
    }

    public TableDefine setColumns(List<ColumnDefine> columns) {
        this.columns = columns;
        return this;
    }
}

