/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.thread;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mini.framework.util.log.trace.LinkTraceFace;
import com.mini.framework.util.log.trace.MethodTracePointer;
import com.mini.framework.util.thread.ObjectThreadCachable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractAsyncThreadExecutor {
    private static Logger logger = LogManager.getLogger(AbstractAsyncThreadExecutor.class);
    private String threadNameFormat = "async-thread-execute-%s";
    private int corePoolSize;
    private int waitingQueueSize;
    private int maximumPoolSize;
    private long keepAliveMilliSeconds;
    private ThreadFactory threadFactory;
    private ExecutorService threadPool;

    public AbstractAsyncThreadExecutor(int corePoolSize, int waitingQueueSize, int maximumPoolSize, long keepAliveMilliSeconds) {
        this.corePoolSize = corePoolSize;
        this.waitingQueueSize = waitingQueueSize;
        this.maximumPoolSize = maximumPoolSize;
        this.keepAliveMilliSeconds = keepAliveMilliSeconds;
        this.afterInit();
    }

    public AbstractAsyncThreadExecutor(String threadNameFormat, int corePoolSize, int waitingQueueSize, int maximumPoolSize, long keepAliveMilliSeconds) {
        this.threadNameFormat = threadNameFormat;
        this.corePoolSize = corePoolSize;
        this.waitingQueueSize = waitingQueueSize;
        this.maximumPoolSize = maximumPoolSize;
        this.keepAliveMilliSeconds = keepAliveMilliSeconds;
        this.afterInit();
    }

    public AbstractAsyncThreadExecutor afterInit() {
        this.threadFactory = new ThreadFactoryBuilder().setNameFormat(this.threadNameFormat).build();
        this.threadPool = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveMilliSeconds, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.waitingQueueSize), this.threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        return this;
    }

    public void execute(Runnable origin) {
        this.threadPool.execute(this.aroundRunnable(origin));
    }

    protected Runnable aroundRunnable(Runnable origin) {
        String siteId = this.getLocalThreadSiteId().get();
        return () -> {
            ObjectThreadCachable<String> localThreadSiteId = this.getLocalThreadSiteId();
            localThreadSiteId.begin();
            localThreadSiteId.set(siteId);
            LinkTraceFace.markSiteId(siteId);
            this.getMethodTracePointer().autoPoint();
            try {
                origin.run();
            }
            finally {
                localThreadSiteId.clear();
                this.getMethodTracePointer().endTrace();
            }
        };
    }

    public abstract ObjectThreadCachable<String> getLocalThreadSiteId();

    public abstract MethodTracePointer getMethodTracePointer();

    public String getThreadNameFormat() {
        return this.threadNameFormat;
    }

    public void setThreadNameFormat(String threadNameFormat) {
        this.threadNameFormat = threadNameFormat;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getWaitingQueueSize() {
        return this.waitingQueueSize;
    }

    public void setWaitingQueueSize(int waitingQueueSize) {
        this.waitingQueueSize = waitingQueueSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public long getKeepAliveMilliSeconds() {
        return this.keepAliveMilliSeconds;
    }

    public void setKeepAliveMilliSeconds(long keepAliveMilliSeconds) {
        this.keepAliveMilliSeconds = keepAliveMilliSeconds;
    }
}

