/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.asserts;

import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.asserts.flag.DatabaseInstanceMapper;
import java.util.Optional;
import java.util.function.Function;

public class AssertBean {
    public static <B, R, E extends CustomException> R requireFieldFromBean(B bean, Function<B, R> fieldGetter, Function<String, E> exceptionSupplier, String errorMessage, Object ... errorParams) throws E {
        R field = fieldGetter.apply(bean);
        AssertUtil.assertNormal(field != null, exceptionSupplier, errorMessage, errorParams);
        return field;
    }

    public static <B, R> R requireFieldFromBean(B bean, Function<B, R> fieldGetter, StatusCode errorCode, String errorMessage, Object ... errorParams) {
        R field = fieldGetter.apply(bean);
        AssertUtil.assertMethodRequire(fieldGetter, "fieldGetter");
        AssertUtil.simpleAssertByStatus(field != null, errorCode, errorMessage, errorParams);
        return field;
    }

    public static <B, R> R requireFieldFromDatabaseBean(B bean, Function<B, R> fieldGetter, Optional<Object> keyOptional, String fieldName, String instanceName) {
        AssertUtil.assertMethodRequire(bean, "bean");
        return AssertBean.requireFieldFromBean(bean, fieldGetter, Status.BadData.missRequireFieldData, "\u7c7b\u578b\u4e3a:[%s]\u7684db\u5b9e\u4f53key:[%s]\u4e2d\u7f3a\u5931\u975e\u7a7a\u5c5e\u6027:[%s]", instanceName, keyOptional.orElse(null), fieldName);
    }

    public static <B extends DatabaseInstanceMapper, R> R requireFieldFromDatabaseBean(B bean, Function<B, R> fieldGetter, String fieldName) {
        AssertUtil.assertMethodRequire(bean, "bean");
        return AssertBean.requireFieldFromDatabaseBean(bean, fieldGetter, bean.showDatabaseInstanceKey(), fieldName, bean.showDatabaseInstanceName());
    }

    public static <B extends DatabaseInstanceMapper, R> R requireFieldFromDatabaseBean(B bean, R fieldNullable, String fieldName) {
        return (R)AssertBean.requireFieldFromDatabaseBean(bean, b -> fieldNullable, fieldName);
    }
}

