/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.bean;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.core.exception.HandleReflectException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ClassUtil {
    @Deprecated
    public static List<Class<?>> getClassFromPackage(Package pack) {
        String packageString = pack.getName();
        String name = packageString.replace(".", "/");
        String packageDir = ClassLoader.getSystemClassLoader().getResource(name).getPath();
        File[] files = new File(packageDir).listFiles();
        List<Class<?>> classes = Stream.of(files).map(File::getName).filter(n -> n.endsWith("class")).map(n -> packageString + "." + n.replace(".class", "")).map(className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new BadReqException((Throwable)e, "\u627e\u4e0d\u5230\u7c7b:%s", new Object[]{className});
            }
        }).collect(Collectors.toList());
        return classes;
    }

    public static List<Class<?>> findClassFromPackage(Package pack) {
        return ClassUtil.findClassFromPackage(pack.getName());
    }

    public static List<Class<?>> findClassFromPackageOfClass(Class<?> clazz) {
        String className = clazz.getName();
        String packageName = StringUtils.substringBeforeLast((String)className, (String)".");
        return ClassUtil.findClassFromPackage(packageName);
    }

    public static List<Class<?>> findClassFromPackageOfClassInstance(Object classInstance) {
        String className = classInstance.getClass().getName();
        String packageName = StringUtils.substringBeforeLast((String)className, (String)".");
        return ClassUtil.findClassFromPackage(packageName);
    }

    public static <B> List<Class<?>> findClassFromPackage(String packageClassPath) {
        String packageFilePath = packageClassPath.replace(".", "/");
        String packagePattern = String.format("classpath*:%s/*", packageClassPath.replace(".", "/"));
        Resource[] resources = ClassUtil.getResourcesByPathPattern(packagePattern);
        return Stream.of(resources).map(Object::toString).map(resourcePath -> resourcePath.replace("\\", "/")).filter(classFilePath -> classFilePath.contains(".class")).map(resourcePath -> {
            String fileNameWithSuffix = StringUtils.substringAfter((String)resourcePath, (String)packageFilePath);
            String classNameWithSplit = StringUtils.substringBeforeLast((String)fileNameWithSuffix, (String)".class");
            return packageFilePath + classNameWithSplit;
        }).map(classFilePath -> classFilePath.replace("/", ".")).map(classPath -> {
            try {
                return Class.forName(classPath);
            }
            catch (ClassNotFoundException e) {
                throw new HandleReflectException((Throwable)e, "\u6839\u636e\u7c7b:[%s]\u89e3\u6790\u6210\u7c7b\u51fa\u9519", new Object[]{classPath});
            }
        }).collect(Collectors.toList());
    }

    public static Resource[] getResourcesByPathPattern(String pathPattern) {
        try {
            return new PathMatchingResourcePatternResolver().getResources(pathPattern);
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u6839\u636e\u8def\u5f84\u6b63\u5219:[%s]\u83b7\u53d6\u8d44\u6e90\u51fa\u9519", new Object[]{pathPattern});
        }
    }
}

