/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.bean;

import com.mini.framework.core.exception.HandleException;
import java.lang.reflect.Field;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;

public class ProxyBeanUtil {
    public static <T> T getTarget(Object proxy) {
        try {
            if (!AopUtils.isAopProxy((Object)proxy)) {
                return (T)proxy;
            }
            if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
                return (T)ProxyBeanUtil.getJdkDynamicProxyTargetObject(proxy);
            }
            return (T)ProxyBeanUtil.getCglibProxyTargetObject(proxy);
        }
        catch (Exception e) {
            throw new HandleException((Throwable)e, "\u53d6%s\u7684\u771f\u5b9e\u7c7b\u51fa\u9519", new Object[]{proxy});
        }
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return target;
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return target;
    }
}

