/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.cache;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.cache.TimeQueueCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;

public class SpringRedisTimeQueueCache
implements TimeQueueCache {
    private Logger logger = LogManager.getLogger(SpringRedisTimeQueueCache.class);
    private RedisTemplate<String, String> redisTemplate;
    protected String redisPrefix;
    protected String redisKey;

    public SpringRedisTimeQueueCache(RedisTemplate<String, String> redisTemplate, String redisPrefix, String redisKey) {
        this.redisTemplate = redisTemplate;
        this.redisPrefix = redisPrefix;
        this.redisKey = redisKey;
    }

    public String getRedisKey() {
        return this.redisKey;
    }

    public void setRedisKey(String redisKey) {
        this.redisKey = redisKey;
    }

    public String getRedisPrefix() {
        return this.redisPrefix;
    }

    public void setRedisPrefix(String redisPrefix) {
        this.redisPrefix = redisPrefix;
    }

    public RedisTemplate<String, String> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public TimeQueueCache write(Date delay, String data) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        String key = this.getCacheKey();
        Boolean success = zset.add((Object)key, (Object)data, (double)delay.getTime());
        this.logger.debug("redis\u65f6\u5e8f\u961f\u5217\u4fdd\u5b58\u7ed3\u679c:{},\u4fdd\u5b58\u6570\u636edate:{},data:{}", (Object)success, (Object)delay.getTime(), (Object)data);
        return this;
    }

    protected String getCacheKey() {
        AssertUtil.assertSupport(this.redisPrefix != null, "redis\u524d\u7f00\u4e0d\u5141\u8bb8\u4e3a\u7a7a", new Object[0]);
        return this.redisPrefix + this.redisKey;
    }

    @Override
    public List<String> readBefore(Date datePoint) {
        String key;
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        Set datas = zset.reverseRangeByScore((Object)(key = this.getCacheKey()), 0.0, (double)datePoint.getTime());
        int size = datas.size();
        if (size > 0) {
            Long remove = zset.removeRangeByScore((Object)key, 0.0, (double)datePoint.getTime());
            this.logger.debug("redis\u65f6\u5e8f\u961f\u5217\u53d1\u73b0{}\u6761\u6570\u636e\u53d6\u51fa{}\u6761\u6570\u636e", (Object)size, (Object)remove);
        }
        return new ArrayList<String>(datas);
    }
}

