/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.cache.annotation.springboot2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mini.framework.util.cache.annotation.springboot2.CustomCacheKeyPrefix;
import com.mini.framework.util.cache.annotation.springboot2.CustomRedisCacheManager;
import com.mini.framework.util.cache.annotation.springboot2.RedisConnectConfig;
import com.mini.framework.util.log.MiniLogLevel;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.SimpleCacheErrorHandler;
import org.springframework.data.redis.cache.CacheKeyPrefix;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class AbstractRedisCacheSupport
extends CachingConfigurerSupport {
    Logger logger = LogManager.getLogger(AbstractRedisCacheSupport.class);
    protected JedisConnectionFactory jedisConnectionFactory;
    protected RedisCacheConfiguration defaultRedisCacheConfiguration;
    protected String cacheNamespace;

    public AbstractRedisCacheSupport(RedisConnectConfig redisConnectConfig, String cacheNamespace) {
        this(AbstractRedisCacheSupport.createJedisConnectionFactory(redisConnectConfig.getHost(), redisConnectConfig.getPort(), redisConnectConfig.getPassword(), redisConnectConfig.getDatabase(), redisConnectConfig.getTimeout()), cacheNamespace);
    }

    protected AbstractRedisCacheSupport() {
    }

    public AbstractRedisCacheSupport(JedisConnectionFactory jedisConnectionFactory, String cacheNamespace) {
        this.afterInit(jedisConnectionFactory, cacheNamespace);
    }

    public void afterInit(JedisConnectionFactory jedisConnectionFactory, String cacheNamespace) {
        this.jedisConnectionFactory = jedisConnectionFactory;
        this.cacheNamespace = cacheNamespace;
        this.defaultRedisCacheConfiguration = AbstractRedisCacheSupport.createBaseCacheConfiguration(this.createKeyPrefix(this.cacheNamespace));
    }

    public static RedisCacheConfiguration createBaseCacheConfiguration(CacheKeyPrefix keyPrefix) {
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(om);
        RedisSerializationContext.SerializationPair pair = RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().computePrefixWith(keyPrefix).entryTtl(Duration.ofSeconds(10L)).serializeValuesWith(pair).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer()));
        return config;
    }

    public static JedisConnectionFactory createJedisConnectionFactory(String host, int port, String password, int database, int timeout) {
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration(host, port);
        redisStandaloneConfiguration.setDatabase(database);
        redisStandaloneConfiguration.setPassword(RedisPassword.of((String)password));
        JedisClientConfiguration jedisClientConfiguration = JedisClientConfiguration.builder().connectTimeout(Duration.ofMillis(timeout)).build();
        return new JedisConnectionFactory(redisStandaloneConfiguration, jedisClientConfiguration);
    }

    public CacheManager cacheManager() {
        CustomCacheKeyPrefix keyPrefix = this.createKeyPrefix(this.cacheNamespace);
        RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)this.jedisConnectionFactory);
        RedisCacheConfiguration defaultCacheConfig = this.defaultRedisCacheConfiguration;
        RedisCacheManager.RedisCacheManagerBuilder.fromConnectionFactory((RedisConnectionFactory)this.jedisConnectionFactory).cacheDefaults(defaultCacheConfig).build().afterPropertiesSet();
        CustomRedisCacheManager cacheManager = new CustomRedisCacheManager(keyPrefix, (RedisConnectionFactory)this.jedisConnectionFactory, redisCacheWriter, defaultCacheConfig);
        return cacheManager;
    }

    public CacheErrorHandler errorHandler() {
        return new SimpleCacheErrorHandler(){

            public void handleCacheGetError(RuntimeException exception, Cache cache, Object key) {
                AbstractRedisCacheSupport.this.logger.error("\u53d6\u7f13\u5b58[{}]\u65f6\u51fa\u9519", key, (Object)exception);
                cache.evict(key);
                AbstractRedisCacheSupport.this.logger.log(MiniLogLevel.getKeyBizLog(), "\u5ffd\u7565\u9519\u8bef \u5e76\u64cd\u4f5c\u5220\u9664\u7f13\u5b58:[{}]", key);
            }
        };
    }

    protected JedisConnectionFactory showJedisConnectionFactory() {
        return this.jedisConnectionFactory;
    }

    protected CustomCacheKeyPrefix createKeyPrefix(String cacheNamespace) {
        return new CustomCacheKeyPrefix(cacheNamespace);
    }
}

