/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.file;

import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.core.exception.HandleNotFoundException;
import com.mini.framework.core.exception.HandleReflectException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.core.io.UrlResource;

public class ExcelUtil {
    public static byte[] writeToByte(LinkedHashMap<String, String> titles, List<Map<String, String>> datas) {
        return ExcelUtil.writeToByte(titles, datas, "sheet1");
    }

    public static byte[] writeToByte(LinkedHashMap<String, String> titles, List<Map<String, String>> datas, String name) {
        Object row;
        int i;
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook();
        HSSFSheet sheet = hssfWorkbook.createSheet(name);
        HSSFRow titleRow = sheet.createRow(0);
        ArrayList<Map.Entry<String, String>> titleList = new ArrayList<Map.Entry<String, String>>(titles.entrySet());
        for (i = 0; i < titleList.size(); ++i) {
            String value = (String)((Map.Entry)titleList.get(i)).getValue();
            HSSFCell cell = titleRow.createCell(i);
            cell.setCellValue(value);
        }
        for (i = 0; i < datas.size(); ++i) {
            row = sheet.createRow(i + 1);
            Map<String, String> data = datas.get(i);
            for (int j = 0; j < titleList.size(); ++j) {
                String key = (String)((Map.Entry)titleList.get(j)).getKey();
                String value = data.get(key);
                HSSFCell cell = row.createCell(j);
                cell.setCellValue(value);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            hssfWorkbook.write((OutputStream)baos);
            row = baos.toByteArray();
            return row;
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u5728\u5199\u51faexcel\u65f6\u51fa\u9519", new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((Closeable)hssfWorkbook);
        }
    }

    @Deprecated
    public static List<Map<String, String>> read(String filepath, boolean header) {
        try {
            return ExcelUtil.read((InputStream)new FileInputStream(filepath), header);
        }
        catch (FileNotFoundException e) {
            throw new HandleNotFoundException((Throwable)e, "\u8bfb\u6587\u4ef6:[%s]\u6d41\u65f6\u51fa\u9519", new Object[]{filepath});
        }
    }

    @Deprecated
    public static List<Map<String, String>> read(InputStream inputStream, boolean header) {
        if (header) {
            return ExcelUtil.readUseHead(inputStream).orElse(null);
        }
        return ExcelUtil.readIncludeHead(inputStream);
    }

    public static List<Map<String, String>> readFromUrlIncludeHead(String resourceUrl) {
        InputStream inputStream = ExcelUtil.readInputStreamFromUrl(resourceUrl);
        return ExcelUtil.read(inputStream);
    }

    public static List<Map<String, String>> readFromPathIncludeHead(String path) {
        InputStream inputStream = ExcelUtil.readInputStreamFromPath(path);
        return ExcelUtil.read(inputStream);
    }

    public static Optional<List<Map<String, String>>> readFromUrlUseHead(String resourceUrl) {
        InputStream inputStream = ExcelUtil.readInputStreamFromUrl(resourceUrl);
        return ExcelUtil.readUseHead(inputStream);
    }

    public static Optional<List<Map<String, String>>> readFromPathUseHead(String path) {
        InputStream inputStream = ExcelUtil.readInputStreamFromPath(path);
        return ExcelUtil.readUseHead(inputStream);
    }

    public static Optional<List<Map<String, String>>> readUseHead(InputStream inputStream) {
        List<Map<String, String>> list = ExcelUtil.read(inputStream);
        return list.stream().findFirst().map(head -> {
            ArrayList result = new ArrayList();
            list.stream().skip(1L).forEach(oldData -> {
                LinkedHashMap newData = new LinkedHashMap();
                result.add(newData);
                for (Map.Entry entry : oldData.entrySet()) {
                    newData.put(head.get(entry.getKey()), entry.getValue());
                }
            });
            return result;
        });
    }

    public static List<Map<String, String>> readIncludeHead(InputStream inputStream) {
        return ExcelUtil.read(inputStream);
    }

    private static InputStream readInputStreamFromUrl(String resourceUrl) {
        UrlResource urlResource = null;
        try {
            urlResource = new UrlResource(new URL(resourceUrl));
            return urlResource.getInputStream();
        }
        catch (MalformedURLException e) {
            throw new HandleIOException((Throwable)e, "url:[%s]\u683c\u5f0f\u9519\u8bef", new Object[]{resourceUrl});
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u5728\u5199\u51faexcel\u65f6\u51fa\u9519", new Object[0]);
        }
    }

    private static InputStream readInputStreamFromPath(String filepath) {
        try {
            return new FileInputStream(filepath);
        }
        catch (FileNotFoundException e) {
            throw new HandleNotFoundException((Throwable)e, "\u8bfb\u6587\u4ef6:[%s]\u6d41\u65f6\u51fa\u9519", new Object[]{filepath});
        }
    }

    public static List<Map<String, String>> read(String filepath) {
        try {
            return ExcelUtil.read(new FileInputStream(new File(filepath)));
        }
        catch (FileNotFoundException e) {
            throw new HandleNotFoundException((Throwable)e, "\u8bfb\u6587\u4ef6:[%s]\u6d41\u65f6\u51fa\u9519", new Object[]{filepath});
        }
    }

    public static List<Map<String, String>> read(InputStream inputStream) {
        List<List<String>> rows = ExcelUtil.readStringRows(inputStream);
        return rows.stream().map(row -> {
            HashMap map = new HashMap();
            for (int index = 0; index < row.size(); ++index) {
                map.put(String.valueOf(index), row.get(index));
            }
            return map;
        }).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    public static List<List<String>> readStringRows(InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <E> List<E> read(String filepath, Class<E> clazz) {
        try {
            return ExcelUtil.read((InputStream)new FileInputStream(new File(filepath)), clazz);
        }
        catch (FileNotFoundException e) {
            throw new HandleNotFoundException((Throwable)e, "\u8bfb\u6587\u4ef6:[%s]\u6d41\u65f6\u51fa\u9519", new Object[]{filepath});
        }
    }

    public static <E> List<E> read(InputStream is, Class<E> clazz) {
        Object obj = null;
        List<Map<String, String>> list = ExcelUtil.read(is, true);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map<String, String> map : list) {
            try {
                obj = clazz.newInstance();
                ExcelUtil.populate(obj, map);
                result.add(obj);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new HandleReflectException((Throwable)e, "\u5b9e\u4f8b\u5316bean\u65f6\u51fa\u9519", new Object[0]);
            }
        }
        return result;
    }

    private static void populate(Object obj, Map<String, ?> map) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (!map.containsKey(key)) continue;
                Object value = map.get(key);
                Method setter = property.getWriteMethod();
                setter.invoke(obj, value);
            }
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new HandleReflectException((Throwable)e, "\u5c1d\u8bd5\u628amap\u8f6c\u5316\u6210bean\u5931\u8d25", new Object[0]);
        }
    }
}

