/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.generic.define;

import com.mini.framework.util.asserts.AssertUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SetString {
    private final Set<String> value;

    public SetString(Set<String> value) {
        this.value = value;
    }

    public static SetString of(String ... strings) {
        return SetString.of(Stream.of(strings).collect(Collectors.toSet()));
    }

    public static SetString of(Set<String> set) {
        AssertUtil.assertMethodRequire(set, "set");
        return new SetString(set);
    }

    public static SetString of(Collection<String> coll) {
        return SetString.of(new HashSet<String>(coll));
    }

    public static <B, B1> SetString of(Collection<B> coll, Function<B, B1> b1Getter, Function<B1, String> stringGetter) {
        return SetString.of(coll, b1Getter.andThen(stringGetter));
    }

    public static <B> SetString of(Collection<B> coll, Function<B, String> stringGetter) {
        return SetString.of(coll.stream().map(stringGetter).collect(Collectors.toSet()));
    }

    public static <B> SetString of(Function<B, String> stringGetter, Collection<B> coll) {
        return SetString.of(coll, stringGetter);
    }

    public SetString copy() {
        return SetString.of(this.out());
    }

    public Set<String> out() {
        return this.value;
    }

    public Stream<String> stream() {
        return this.value.stream();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }
}

