/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.http;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.util.asserts.AssertUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpResStatusUtil {
    private static Logger logger = LogManager.getLogger(HttpResStatusUtil.class);

    private static RequestConfig createValiConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(1000);
        builder.setConnectionRequestTimeout(1000);
        builder.setSocketTimeout(1000);
        builder.setMaxRedirects(0);
        return builder.build();
    }

    public static Predicate<String> isExistMatch() {
        return url -> HttpResStatusUtil.isExist(url);
    }

    public static boolean isExist(String urlStr) {
        return HttpResStatusUtil.isExist(urlStr, 1000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isExist(String urlStr, int connectTimeout) {
        if (StringUtils.isEmpty((CharSequence)urlStr)) {
            return false;
        }
        AssertUtil.assertMethodRequire(urlStr, "urlStr");
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(urlStr);
        httpGet.setConfig(HttpResStatusUtil.createValiConfig());
        try (CloseableHttpResponse resp = closeableHttpClient.execute((HttpUriRequest)httpGet);){
            int status = resp.getStatusLine().getStatusCode();
            boolean bl = status / 100 == 2;
            return bl;
        }
        catch (IOException e) {
            logger.debug("\u5c1d\u8bd5\u8bbf\u95ee\u51fa\u9519url:{}", (Object)urlStr, (Object)e);
            return false;
        }
    }

    public static byte[] readResUrl(String resUrl) {
        AssertUtil.assertMethodRequire(resUrl, "resUrl");
        try {
            URL url = new URL(resUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            InputStream inputStream = connection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (MalformedURLException e) {
            throw new BadReqException((Throwable)e, "\u8d44\u6e90[%s]\u683c\u5f0f\u9519\u8bef", new Object[]{resUrl});
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "read resUrl error url:[%s]", new Object[]{resUrl});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File readResUrlAsFile(String resUrl, String filePath) {
        byte[] data = HttpResStatusUtil.readResUrl(resUrl);
        try (FileOutputStream fos = new FileOutputStream(new File(filePath));){
            IOUtils.write((byte[])data, (OutputStream)fos);
            File file = new File(filePath);
            return file;
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u628a\u5b57\u8282\u6d41\u5199\u5230\u6587\u4ef6\u51fa\u9519resUrl:[%s]", new Object[]{resUrl});
        }
    }
}

