/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.log.trace;

import com.mini.framework.util.log.MiniLogLevel;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

public class LinkTraceFace {
    private static String serverId;
    private static String colonyIndex;
    private static final Logger logger;
    private static final String LINK_FEATHRE_LOG = "LINK_FEATHRE_LOG";
    private static final String MILLI_SECOND_FORMAT = "yyyyMMddHHmmssSSS";
    static final String BEGIN_POINT = "BEGIN_POINT";
    static final String BEGIN_POINT_RANDOM = "BEGIN_POINT_RANDOM";
    public static final String TRACE_ID = "ti";
    public static final String logUserPatternKey = "userKey";
    public static final String logSiteIdPatternKey = "siteId";
    public static final String logAppIndexPatternKey = "appIndex";

    public static void linkBeginPoint(String feature) {
        if (feature != null) {
            ThreadContext.put((String)LINK_FEATHRE_LOG, (String)feature);
        }
        LinkTraceFace.setBeginPoint();
        LinkTraceFace.resetTraceId();
    }

    public static void clearTrace() {
        ThreadContext.remove((String)TRACE_ID);
        ThreadContext.remove((String)BEGIN_POINT);
        ThreadContext.remove((String)BEGIN_POINT_RANDOM);
        ThreadContext.remove((String)logAppIndexPatternKey);
        ThreadContext.remove((String)logSiteIdPatternKey);
        ThreadContext.remove((String)logUserPatternKey);
    }

    public static void setAsyncLogSystemProperty() {
        System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
    }

    private static void resetTraceId() {
        Long time = LinkTraceFace.getBeginPoint();
        String pointTimeString = null;
        if (time != null) {
            String random = ThreadContext.get((String)BEGIN_POINT_RANDOM);
            pointTimeString = DateFormatUtils.format((long)time, (String)MILLI_SECOND_FORMAT) + random;
        }
        String feature = ThreadContext.get((String)LINK_FEATHRE_LOG);
        String traceId = (feature == null ? "" : serverId + colonyIndex + feature) + (pointTimeString == null ? "" : pointTimeString);
        String oldTraceId = ThreadContext.get((String)TRACE_ID);
        if (oldTraceId != null && oldTraceId.length() != 0 && !oldTraceId.equals(traceId)) {
            logger.log(MiniLogLevel.getFrameWorkLog(), String.format("change trace id target:[%s],old:[%s]", traceId, oldTraceId));
        }
        ThreadContext.put((String)TRACE_ID, (String)traceId);
    }

    private static long setBeginPoint() {
        long time = System.currentTimeMillis();
        String random = RandomStringUtils.randomNumeric((int)6);
        ThreadContext.put((String)BEGIN_POINT_RANDOM, (String)random);
        ThreadContext.put((String)BEGIN_POINT, (String)String.valueOf(time));
        return time;
    }

    private static Long getBeginPoint() {
        long year;
        long beginPoint;
        String beginPointStr = ThreadContext.get((String)BEGIN_POINT);
        if (StringUtils.isNumeric((CharSequence)beginPointStr) && (beginPoint = Long.parseLong(beginPointStr)) > (year = 31536000000L) * 30L && beginPoint < year * 300L) {
            return beginPoint;
        }
        return null;
    }

    public static void markUserKey(String userKey) {
        if (userKey != null) {
            ThreadContext.put((String)logUserPatternKey, (String)userKey);
        }
    }

    public static void markSiteId(String siteId) {
        if (siteId != null) {
            ThreadContext.put((String)logSiteIdPatternKey, (String)siteId);
        }
    }

    public static void markAppIndex(String appIndex) {
        if (appIndex != null) {
            ThreadContext.put((String)logAppIndexPatternKey, (String)appIndex);
        }
    }

    public static Optional<Long> countThreadUserTime() {
        return LinkTraceFace.countThreadUserTime((ReadOnlyStringMap)ThreadContext.getThreadContextMap().getReadOnlyContextData());
    }

    public static Optional<Long> countThreadUserTime(ReadOnlyStringMap readOnlyThreadContextMap) {
        return LinkTraceFace.countThreadUserTime(readOnlyThreadContextMap.toMap());
    }

    public static Optional<Long> countThreadUserTime(Map<String, String> readOnlyThreadContextMap) {
        long beginPoint;
        long userTime;
        long now = System.currentTimeMillis();
        String beginPointStr = readOnlyThreadContextMap.get(BEGIN_POINT);
        if (StringUtils.isNumeric((CharSequence)beginPointStr) && (userTime = now - (beginPoint = Long.parseLong(beginPointStr))) >= 0L) {
            return Optional.ofNullable(userTime);
        }
        return Optional.empty();
    }

    public static String showTraceId() {
        return ThreadContext.get((String)TRACE_ID);
    }

    public static void setServerId(String serverId) {
        LinkTraceFace.serverId = serverId;
    }

    public static void setColonyIndex(String colonyIndex) {
        LinkTraceFace.colonyIndex = colonyIndex;
    }

    public static String getServerId() {
        return serverId;
    }

    public static String getColonyIndex() {
        return colonyIndex;
    }

    public static void pointSystemBoot() {
        LinkTraceFace.linkBeginPoint("900001");
    }

    public static void pointSystemQuartz() {
        LinkTraceFace.linkBeginPoint("900002");
    }

    public static void pointTemporary() {
        LinkTraceFace.linkBeginPoint("900003");
    }

    public static void pointUnknownFeature() {
        LinkTraceFace.linkBeginPoint("900104");
    }

    public static void pointRequiredFeature() {
        LinkTraceFace.linkBeginPoint("900005");
    }

    public static void pointInitWorkFeature() {
        LinkTraceFace.linkBeginPoint("900006");
    }

    static {
        logger = LogManager.getLogger(LinkTraceFace.class);
    }
}

