/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.oss.bean.work.mark;

import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.oss.bean.OssImageProcessParams;
import com.mini.framework.util.oss.bean.work.OssImageWork;
import com.mini.framework.util.oss.bean.work.mark.HaveMarkPhotoFrame;
import com.mini.framework.util.oss.bean.work.mark.MarkOssImageWork;
import com.mini.framework.util.oss.bean.work.modify.CircleByRadiusOssImageWork;
import com.mini.framework.util.oss.bean.work.type.OriginType;
import com.mini.framework.util.oss.bean.work.type.WorkActionType;
import com.mini.framework.util.photo.PhotoBodilyFormType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;

@Desc(value="\u56fe\u7247\u6c34\u5370")
public class ImageMarkOssImageWork
extends MarkOssImageWork
implements HaveMarkPhotoFrame {
    @Desc(value="\u6c34\u5370\u56fe\u7684\u76f8\u5bf9\u7684\u5b8c\u6574\u5730\u5740")
    private @Desc(value="\u6c34\u5370\u56fe\u7684\u76f8\u5bf9\u7684\u5b8c\u6574\u5730\u5740") String image;
    @Desc(value="\u5728\u505a\u6c34\u5370\u524d\u7684\u4fee\u6539\u64cd\u4f5c")
    private @Desc(value="\u5728\u505a\u6c34\u5370\u524d\u7684\u4fee\u6539\u64cd\u4f5c") List<OssImageWork> beforeWorks;
    @Desc(value="\u6c34\u5370\u5e0c\u671b\u53c2\u6570\u56fe\u7247\u7684\u7c7b\u578b\uff0c\u6709\u8fd9\u4e2a\u7c7b\u578b\u4f1a\u5f15\u5bfc\u4f20\u5165\u7684\u53c2\u6570")
    private @Desc(value="\u6c34\u5370\u5e0c\u671b\u53c2\u6570\u56fe\u7247\u7684\u7c7b\u578b\uff0c\u6709\u8fd9\u4e2a\u7c7b\u578b\u4f1a\u5f15\u5bfc\u4f20\u5165\u7684\u53c2\u6570") PhotoBodilyFormType frameScheme;

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public List<OssImageWork> getBeforeWorks() {
        return this.beforeWorks;
    }

    public void setBeforeWorks(List<OssImageWork> beforeWorks) {
        this.beforeWorks = beforeWorks;
    }

    public PhotoBodilyFormType getFrameScheme() {
        return this.frameScheme;
    }

    public void setFrameScheme(PhotoBodilyFormType frameScheme) {
        this.frameScheme = frameScheme;
    }

    public ImageMarkOssImageWork addBeforeWorks(OssImageWork ... beforeWorks) {
        if (this.beforeWorks == null) {
            this.beforeWorks = new ArrayList<OssImageWork>();
        }
        CollectionUtils.addAll(this.beforeWorks, (Object[])beforeWorks);
        return this;
    }

    @Override
    public List<PhotoBodilyFormType> showFrameSchemes() {
        return Stream.of(this.frameScheme).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ImageMarkOssImageWork() {
    }

    public ImageMarkOssImageWork(String image) {
        this.image = image;
    }

    @Override
    public OssImageProcessParams mapperProcessParams(Function<String, String> sureSameBucket) {
        String image = sureSameBucket.apply(this.image);
        if (this.beforeWorks != null) {
            boolean unsopportType = this.beforeWorks.stream().map(OssImageWork::getWorkType).anyMatch(type -> type.matchType(WorkActionType.circleByRadius));
            AssertUtil.assertNoBadReq(!unsopportType, Status.BadReq.unsupportParam, "\u6c34\u5370\u4e0d\u652f\u6301circleByRadius\u5904\u7406\u9700\u8981\u5904\u7406\u5207\u5706\u53ef\u4ee5\u8d70circleByRoundedCorners", new Object[0]);
            List<OssImageProcessParams> processes = this.beforeWorks.stream().map(beforeWork -> beforeWork.mapperProcessParams(sureSameBucket)).collect(Collectors.toList());
            image = OssImageProcessParams.applyMultiParams(image, processes);
        }
        return super.mapperProcessParams(sureSameBucket).paramBase64("image", image);
    }

    public static List<ImageMarkOssImageWork> createExamples() {
        ArrayList<ImageMarkOssImageWork> examples = new ArrayList<ImageMarkOssImageWork>();
        ImageMarkOssImageWork example = new ImageMarkOssImageWork("${\u8fd9\u91cc\u5199\u56fe\u7247\u5360\u4f4d\u7b26}");
        example.addBeforeWorks(new CircleByRadiusOssImageWork(30)).fillParams(80, OriginType.nw, 100, 500, null).fillParams(14.0, "\u589e\u52a0\u4e00\u4e2a\u56fe\u7247\u6c34\u5370\uff0c\u9700\u8981\u81ea\u884c\u4fee\u6539\u5360\u4f4d\u7b26");
        examples.add(example);
        return examples;
    }
}

